/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.test.queue.server.services;

import org.autumnframework.service.api.dtos.Identifiable;
import org.autumnframework.service.queue.api.client.listener.CrudQueueListener;
import org.autumnframework.service.queue.api.messages.IdentifiableMessage;
import org.autumnframework.service.queue.api.server.services.SenderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageListenerService<I extends Identifiable, M extends IdentifiableMessage<I>>
implements CrudQueueListener<I, M> {
    private static final Logger log = LoggerFactory.getLogger(AbstractMessageListenerService.class);
    private final SenderService<I, M> messageSender;

    public AbstractMessageListenerService(SenderService<I, M> messageSender) {
        this.messageSender = messageSender;
    }

    public void handleCreate(M message) {
        log.trace("handleCreate {}", message);
        this.messageSender.sendCreate(message);
    }

    public void handleUpdate(M message) {
        log.trace("handleProviderUpdate {}", message);
        this.messageSender.sendCreate(message);
    }

    public void handleDelete(M message) {
        log.trace("handleProviderDelete {}", message);
        this.messageSender.sendCreate(message);
    }
}

