/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.test.queue.server.services;

import lombok.extern.slf4j.Slf4j;
import org.autumnframework.service.test.api.PersonDTO;
import org.autumnframework.service.test.api.PersonMessage;
import org.autumnframework.service.test.api.SomeDTO;
import org.autumnframework.service.test.api.SomeMessage;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.UUID;

/**
 * @author Timon Veenstra
 */
@Service
@Slf4j
public class MessageProducerService {

    private final TestSenderService senderService;
    private final PersonSenderService personSenderService;

    public MessageProducerService(TestSenderService senderService, PersonSenderService personSenderService) {
        this.senderService = senderService;
        this.personSenderService = personSenderService;
    }

    @Async
    @Scheduled(fixedRate = 1000)
    public void sendCreate(){
        log.trace("sendCreate");
        senderService.sendCreate(SomeMessage
                .builder()
                .payload(SomeDTO
                        .builder()
                        .id(UUID.randomUUID())
                        .someProperty("CREATE")
                        .someDate(LocalDate.of(2020,01,01))
                        .someDateTime(LocalDateTime.MAX)
                        .build())
                .build());

        personSenderService.sendCreate(PersonMessage.builder()
                .payload(PersonDTO.builder()
                        .firstName("John")
                        .lastName("Applebottom")
                        .id(UUID.randomUUID())
                        .build())
                .messageChainId(UUID.randomUUID())
                .build());

    }

    @Async
    @Scheduled(fixedRate = 3000)
    public void sendUpdate(){
        log.trace("sendUpdate");
        senderService.sendUpdate(SomeMessage
                .builder()
                .payload(SomeDTO
                        .builder()
                        .id(UUID.randomUUID())
                        .someProperty("UPDATE")
                        .someDate(LocalDate.of(2020,01,01))
                        .someDateTime(LocalDateTime.MAX)
                        .build())
                .build());
    }

    @Async
    @Scheduled(fixedRate = 5000)
    public void sendDelete(){
        log.trace("sendDelete");
        senderService.sendDelete(SomeMessage
                .builder()
                .payload(SomeDTO
                        .builder()
                        .id(UUID.randomUUID())
                        .someProperty("DELETE")
                        .someDate(LocalDate.of(2020,01,01))
                        .someDateTime(LocalDateTime.MAX)
                        .build())
                .build());
    }
}
