/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.test.queue.server.services;

import lombok.extern.slf4j.Slf4j;
import org.autumnframework.service.api.dtos.Identifiable;
import org.autumnframework.service.queue.api.client.listener.CrudQueueListener;
import org.autumnframework.service.queue.api.messages.IdentifiableMessage;
import org.autumnframework.service.queue.api.server.services.SenderService;

/**
 * Our delegating service uses CrudQueueListener.getMessageType() to determine how it should route a message to a specific
 * CrudQueueListener interface. This test verifies that we can have an abstraction layer in between the CrudQueueListener interface
 * and the end-class. It succeeds if getMessageType() can still resolve the correct message type.
 */
@Slf4j
public abstract class AbstractMessageListenerService<I extends Identifiable, M extends IdentifiableMessage<I>> implements CrudQueueListener<I, M> {

    private final SenderService<I, M> messageSender;

    public AbstractMessageListenerService(SenderService<I, M> messageSender) {
        this.messageSender = messageSender;
    }

    @Override
    public void handleCreate(M message) {
        log.trace("handleCreate {}",message);
        messageSender.sendCreate(message);
    }

    @Override
    public void handleUpdate(M message) {
        log.trace("handleProviderUpdate {}",message);
        messageSender.sendCreate(message);
    }

    @Override
    public void handleDelete(M message) {
        log.trace("handleProviderDelete {}",message);
        messageSender.sendCreate(message);
    }
}
