/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.test.api;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.UUID;
import org.autumnframework.service.api.dtos.AuditedIdentifiable;

public class PersonDTO
implements AuditedIdentifiable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private UUID id;
    @NotBlank
    private String firstName;
    private String lastName;
    private LocalDateTime lastModifiedDate;
    private LocalDateTime creationDate;

    public static PersonDTOBuilder builder() {
        return new PersonDTOBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public LocalDateTime getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public LocalDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setLastModifiedDate(LocalDateTime lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setCreationDate(LocalDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public String toString() {
        return "PersonDTO(id=" + this.getId() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", lastModifiedDate=" + this.getLastModifiedDate() + ", creationDate=" + this.getCreationDate() + ")";
    }

    public PersonDTO() {
    }

    public PersonDTO(UUID id, String firstName, String lastName, LocalDateTime lastModifiedDate, LocalDateTime creationDate) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.lastModifiedDate = lastModifiedDate;
        this.creationDate = creationDate;
    }

    public static class PersonDTOBuilder {
        private UUID id;
        private String firstName;
        private String lastName;
        private LocalDateTime lastModifiedDate;
        private LocalDateTime creationDate;

        PersonDTOBuilder() {
        }

        public PersonDTOBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        public PersonDTOBuilder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public PersonDTOBuilder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public PersonDTOBuilder lastModifiedDate(LocalDateTime lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public PersonDTOBuilder creationDate(LocalDateTime creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public PersonDTO build() {
            return new PersonDTO(this.id, this.firstName, this.lastName, this.lastModifiedDate, this.creationDate);
        }

        public String toString() {
            return "PersonDTO.PersonDTOBuilder(id=" + this.id + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", lastModifiedDate=" + this.lastModifiedDate + ", creationDate=" + this.creationDate + ")";
        }
    }
}

