/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.test.api;

import java.util.UUID;
import org.autumnframework.service.api.dtos.Identifiable;
import org.autumnframework.service.queue.api.messages.IdentifiableMessage;
import org.autumnframework.service.test.api.PersonDTO;

public class PersonMessage
extends IdentifiableMessage<PersonDTO> {
    public PersonMessage(PersonDTO payload, UUID messageChainId) {
        super((Identifiable)payload, messageChainId);
    }

    public static PersonMessageBuilder builder() {
        return new PersonMessageBuilder();
    }

    public PersonMessage() {
    }

    public String toString() {
        return "PersonMessage(super=" + super.toString() + ")";
    }

    public static class PersonMessageBuilder {
        private PersonDTO payload;
        private UUID messageChainId;

        PersonMessageBuilder() {
        }

        public PersonMessageBuilder payload(PersonDTO payload) {
            this.payload = payload;
            return this;
        }

        public PersonMessageBuilder messageChainId(UUID messageChainId) {
            this.messageChainId = messageChainId;
            return this;
        }

        public PersonMessage build() {
            return new PersonMessage(this.payload, this.messageChainId);
        }

        public String toString() {
            return "PersonMessage.PersonMessageBuilder(payload=" + this.payload + ", messageChainId=" + this.messageChainId + ")";
        }
    }
}

