/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.test.api;


import java.time.LocalDateTime;
import java.util.UUID;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.autumnframework.service.api.dtos.AuditedIdentifiable;

@Getter
@Setter
@Builder
@ToString(callSuper = false)
@NoArgsConstructor
@AllArgsConstructor
public class PersonDTO implements AuditedIdentifiable {

    private static final long serialVersionUID = 1L;
    
    @NotNull
    private UUID id;

    @NotBlank
    private String firstName;
    private String lastName;
    
    private LocalDateTime lastModifiedDate;

    private LocalDateTime creationDate;

}
