/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.csv.server.controllers.elementary.helper;

import com.google.common.base.CaseFormat;
import jakarta.persistence.Id;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.ArraySorter;
import org.apache.commons.lang3.builder.ToStringExclude;
import org.autumnframework.service.api.dtos.Identifiable;
import org.autumnframework.service.jpa.entities.ApiEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToStringHelper {
    private static final Logger log = LoggerFactory.getLogger(ToStringHelper.class);
    List<Field> fields;
    List<String> excludeFields;
    boolean camelCaseHeader = true;

    public ToStringHelper(Class<?> clazz, List<String> excludeFields) {
        this.excludeFields = excludeFields;
        this.fields = this.getFieldsFromClass(clazz);
    }

    public ToStringHelper(Class<?> clazz, List<String> excludeFields, boolean camelCaseHeader) {
        this.excludeFields = excludeFields;
        this.fields = this.getFieldsFromClass(clazz);
        this.camelCaseHeader = camelCaseHeader;
    }

    private List<Field> getFieldsFromClass(Class<?> clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        AccessibleObject[] fields = (Field[])ArraySorter.sort((Object[])clazz.getDeclaredFields(), Comparator.comparing(Field::getName));
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            if (!this.accept((Field)field)) continue;
            list.add((Field)field);
        }
        return list;
    }

    protected boolean accept(Field field) {
        if (field.getName().indexOf(36) != -1) {
            return false;
        }
        if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        if (field.getAnnotation(Id.class) != null) {
            return false;
        }
        if (this.excludeFields != null && this.excludeFields.contains(field.getName())) {
            return false;
        }
        return !field.isAnnotationPresent(ToStringExclude.class);
    }

    public <T> void writeObjects(List<T> objects, Writer out) {
        objects.stream().forEach(o -> {
            try {
                this.writeObject(o, out);
            }
            catch (IOException | IllegalAccessException | IllegalArgumentException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    public <T> void writeObject(T object, Writer out) throws IllegalArgumentException, IllegalAccessException, IOException {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (Field field : this.fields) {
            String value = ToStringHelper.addQuote(this.getAndStringifyValue(field, object));
            if (!first) {
                buf.append(",");
            } else {
                first = false;
            }
            buf.append(value);
        }
        buf.append("\n");
        out.write(buf.toString());
    }

    private String getAndStringifyValue(Field field, Object object) throws IllegalArgumentException, IllegalAccessException {
        Object val = field.get(object);
        return this.getValue(val);
    }

    private String getValue(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Identifiable) {
            return ((UUID)((Identifiable)val).getId()).toString();
        }
        if (val instanceof ApiEntity) {
            return ((ApiEntity)val).getApiId().toString();
        }
        if (val instanceof Collection) {
            StringBuffer buffer = new StringBuffer();
            boolean first = true;
            for (Object obj : (Collection)val) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                buffer.append(this.getValue(obj));
            }
            return buffer.toString();
        }
        if (val instanceof LocalDateTime) {
            return ((LocalDateTime)val).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        if (val instanceof LocalDate) {
            return ((LocalDate)val).format(DateTimeFormatter.ISO_LOCAL_DATE);
        }
        return val.toString();
    }

    public static String addQuote(String pValue) {
        if (pValue == null) {
            return null;
        }
        if (pValue.contains("\"")) {
            pValue = pValue.replace("\"", "\"\"");
        }
        if (pValue.contains(",") || pValue.contains("\n") || pValue.contains("'") || pValue.contains("\\") || pValue.contains("\"")) {
            return "\"" + pValue + "\"";
        }
        return pValue;
    }

    public void writeHeader(Writer out) throws IOException {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (Field field : this.fields) {
            String value = ToStringHelper.addQuote(this.properCase(field.getName()));
            if (!first) {
                buf.append(",");
            } else {
                first = false;
            }
            buf.append(value);
        }
        buf.append("\n");
        out.write(buf.toString());
    }

    private String properCase(String name) {
        return this.camelCaseHeader ? name : CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<String> getExcludeFields() {
        return this.excludeFields;
    }
}

