/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.csv.server.controllers.elementary;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.autumnframework.service.api.dtos.Identifiable;
import org.autumnframework.service.csv.server.controllers.elementary.helper.ToStringHelper;
import org.autumnframework.service.jpa.entities.ApiEntity;
import org.autumnframework.service.jpa.services.FullApiService;
import org.autumnframework.service.mappers.DtoEntityMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

public interface CsvDownloadController<DTO extends Identifiable, T extends ApiEntity> {
    public static final Logger log = LoggerFactory.getLogger(CsvDownloadController.class);

    public FullApiService<T> getService();

    public DtoEntityMapper<DTO, T> getMapper();

    @GetMapping(path={""}, produces={"text/csv"})
    default public void downloadDtoCsv(Pageable page, @RequestParam(name="camelCaseHeader", defaultValue="true") boolean camelCaseHeader, HttpServletResponse response) throws IOException {
        if (page == null) {
            page = Pageable.unpaged();
        }
        this.returnCsv(this.getDtoCsvContent(page), response, camelCaseHeader);
    }

    @GetMapping(path={"/since/{date}"}, produces={"text/csv"})
    default public void downloadDtoCsv(@PathVariable(name="date", required=true) LocalDateTime date, @RequestParam(name="camelCaseHeader", defaultValue="true") boolean camelCaseHeader, Pageable page, HttpServletResponse response) throws IOException {
        if (page == null) {
            page = Pageable.unpaged();
        }
        this.returnCsv(this.getDtoCsvContent(date, page), response, camelCaseHeader);
    }

    @GetMapping(path={"/between/{start}/{end}"}, produces={"text/csv"})
    default public void downloadDtoCsv(@PathVariable(name="start", required=true) LocalDateTime start, @PathVariable(name="end", required=true) LocalDateTime end, @RequestParam(name="camelCaseHeader", defaultValue="true") boolean camelCaseHeader, Pageable page, HttpServletResponse response) throws IOException {
        if (page == null) {
            page = Pageable.unpaged();
        }
        this.returnCsv(this.getDtoCsvContent(start, end, page), response, camelCaseHeader);
    }

    default public void returnCsv(List<DTO> records, HttpServletResponse response, boolean camelCaseHeader) throws IOException {
        if (CollectionUtils.isNotEmpty(records)) {
            ToStringHelper helper = new ToStringHelper(((Identifiable)records.get(0)).getClass(), this.getDtoExcludeFieldNames(), camelCaseHeader);
            String csvName = this.getDtoCsvName(records);
            response.setContentType("text/csv; charset=utf-8");
            response.addHeader("Content-Disposition", String.format("attachment ; filename = \"%s.csv\"", csvName));
            PrintWriter writer = response.getWriter();
            helper.writeHeader(writer);
            helper.writeObjects(records, writer);
        }
    }

    default public String getDtoCsvName() {
        return null;
    }

    default public List<String> getDtoExcludeFieldNames() {
        return Collections.emptyList();
    }

    default public List<DTO> getDtoCsvContent(Pageable page) {
        return this.getService().findAll(page).map(this.getCsvMappingFunction()::apply).getContent();
    }

    default public List<DTO> getDtoCsvContent(LocalDateTime date, Pageable page) {
        return this.getService().findAllModifiedSince(date, page).map(this.getCsvMappingFunction()::apply).getContent();
    }

    default public List<DTO> getDtoCsvContent(LocalDateTime start, LocalDateTime end, Pageable page) {
        return this.getService().findAllModifiedBetween(start, end, page).map(this.getCsvMappingFunction()::apply).getContent();
    }

    default public Function<T, DTO> getCsvMappingFunction() {
        return arg_0 -> this.getMapper().mapToDTO(arg_0);
    }

    default public String getDtoCsvName(List<DTO> records) {
        String name = this.getDtoCsvName();
        if (name == null && CollectionUtils.isNotEmpty(records)) {
            return ((Identifiable)records.get(0)).getClass().getSimpleName();
        }
        return "output";
    }
}

