/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.csv.server.controllers.elementary;

import jakarta.persistence.EntityManager;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.time.LocalDateTime;
import java.util.stream.Stream;
import org.autumnframework.service.api.dtos.AuditedIdentifiable;
import org.autumnframework.service.csv.server.controllers.elementary.CsvDownloadController;
import org.autumnframework.service.csv.server.controllers.elementary.helper.ToStringHelper;
import org.autumnframework.service.jpa.entities.ApiEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

public interface AuditedCsvDownloadController<DTO extends AuditedIdentifiable, T extends ApiEntity>
extends CsvDownloadController<DTO, T> {
    public static final Logger log = LoggerFactory.getLogger(AuditedCsvDownloadController.class);

    public EntityManager getEntityManager();

    @GetMapping(path={"/stream"}, produces={"text/event-stream"})
    default public void streamDtoCsv(@RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="camelCase", required=false, defaultValue="true") boolean camelCaseHeader, HttpServletResponse response) throws IOException {
        this.streamCsv(this.getDtoCsvContentStream(), response, offset, camelCaseHeader);
    }

    @GetMapping(path={"/stream/since/{date}"}, produces={"text/event-stream"})
    default public void streamDtoCsv(@PathVariable(name="date", required=true) LocalDateTime date, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="camelCaseHeader", required=false, defaultValue="true") boolean camelCaseHeader, HttpServletResponse response) throws IOException {
        this.streamCsv(this.getDtoCsvContentStream(date), response, offset, camelCaseHeader);
    }

    @GetMapping(path={"/stream/between/{start}/{end}"}, produces={"text/event-stream"})
    default public void streamDtoCsv(@PathVariable(name="start", required=true) LocalDateTime start, @PathVariable(name="end", required=true) LocalDateTime end, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="camelCaseHeader", required=false, defaultValue="true") boolean camelCaseHeader, HttpServletResponse response) throws IOException {
        this.streamCsv(this.getDtoCsvContentStream(start, end), response, offset, camelCaseHeader);
    }

    default public Stream<T> getDtoCsvContentStream() {
        return this.getService().streamAll();
    }

    default public Stream<T> getDtoCsvContentStream(@NonNull LocalDateTime date) {
        return this.getService().getRepository().streamAllByLastModifiedDateAfterOrderByCreationDate(date);
    }

    default public Stream<T> getDtoCsvContentStream(@NonNull LocalDateTime start, @NonNull LocalDateTime end) {
        return this.getService().getRepository().streamAllByLastModifiedDateBetweenOrderByCreationDate(start, end);
    }

    default public void streamCsv(Stream<T> records, HttpServletResponse response, int offset, boolean camelCaseHeader) throws IOException {
        PrintWriter writer = response.getWriter();
        StreamHelper helper = new StreamHelper();
        helper.setWriter(writer);
        records.map(this::mapAndDetach).skip(offset).forEach(record -> {
            if (helper.getHelper() == null) {
                helper.setHelper(new ToStringHelper(record.getClass(), this.getDtoExcludeFieldNames(), camelCaseHeader));
                response.setContentType("text/event-stream; charset=utf-8");
                helper.writeHeader();
            }
            helper.writeObject(record);
        });
    }

    default public DTO mapAndDetach(T entity) {
        AuditedIdentifiable dto = (AuditedIdentifiable)this.getCsvMappingFunction().apply(entity);
        this.getEntityManager().detach(entity);
        return (DTO)dto;
    }

    public static class StreamHelper<DTO> {
        ToStringHelper helper = null;
        Writer writer = null;

        public void writeHeader() {
            try {
                this.helper.writeHeader(this.writer);
            }
            catch (IOException ioe) {
                log.error(ioe.getMessage(), (Throwable)ioe);
            }
        }

        public void writeObject(DTO d) {
            try {
                this.helper.writeObject(d, this.writer);
            }
            catch (IOException | IllegalAccessException ioe) {
                log.error(ioe.getMessage(), (Throwable)ioe);
            }
        }

        public ToStringHelper getHelper() {
            return this.helper;
        }

        public Writer getWriter() {
            return this.writer;
        }

        public void setHelper(ToStringHelper helper) {
            this.helper = helper;
        }

        public void setWriter(Writer writer) {
            this.writer = writer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StreamHelper)) {
                return false;
            }
            StreamHelper other = (StreamHelper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ToStringHelper this$helper = this.getHelper();
            ToStringHelper other$helper = other.getHelper();
            if (this$helper == null ? other$helper != null : !this$helper.equals(other$helper)) {
                return false;
            }
            Writer this$writer = this.getWriter();
            Writer other$writer = other.getWriter();
            return !(this$writer == null ? other$writer != null : !this$writer.equals(other$writer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StreamHelper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ToStringHelper $helper = this.getHelper();
            result = result * 59 + ($helper == null ? 43 : $helper.hashCode());
            Writer $writer = this.getWriter();
            result = result * 59 + ($writer == null ? 43 : $writer.hashCode());
            return result;
        }

        public String toString() {
            return "AuditedCsvDownloadController.StreamHelper(helper=" + this.getHelper() + ", writer=" + this.getWriter() + ")";
        }
    }
}

