/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.csv.server.controllers.implementations;

import lombok.Getter;
import org.autumnframework.service.api.dtos.AuditedIdentifiable;
import org.autumnframework.service.csv.server.controllers.CsvController;
import org.autumnframework.service.jpa.entities.ApiEntity;
import org.autumnframework.service.jpa.services.FullApiService;
import org.autumnframework.service.mappers.DtoEntityMapper;
import org.autumnframework.service.server.controllers.implementations.FullRestController;

/**
 * @param <DTO>
 * @param <T>
 */
@Getter
public abstract class CsvFullRestController<DTO extends AuditedIdentifiable,
                                           T extends ApiEntity> extends FullRestController<DTO, T>
                                           implements CsvController<DTO, T> {

    /**
     * @param mapper
     * @param service
     */
    public CsvFullRestController(DtoEntityMapper<DTO, T> mapper,
                              FullApiService<T> service) {
        super(mapper, service);
    }
}
