/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.rabbit.client.listener;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.annotation.Timed;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.autumnframework.service.event.metadata.EventMetaData;
import org.autumnframework.service.queue.api.client.listener.CrudQueueListener;
import org.autumnframework.service.queue.api.client.listener.OnQueueCreateListener;
import org.autumnframework.service.queue.api.client.listener.OnQueueDeleteListener;
import org.autumnframework.service.queue.api.client.listener.OnQueueUpdateListener;
import org.autumnframework.service.queue.api.client.listener.batch.CrudQueueBatchListener;
import org.autumnframework.service.queue.api.client.listener.batch.OnQueueBatchCreateListener;
import org.autumnframework.service.queue.api.client.listener.batch.OnQueueBatchDeleteListener;
import org.autumnframework.service.queue.api.client.listener.batch.OnQueueBatchUpdateListener;
import org.autumnframework.service.queue.api.client.listener.shared.MessageTyped;
import org.autumnframework.service.queue.api.messages.GenericIdentifiableMessage;
import org.autumnframework.service.queue.api.messages.IdentifiableMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class CrudMessageListenerAndDelegationService {
    private static final Logger log = LoggerFactory.getLogger(CrudMessageListenerAndDelegationService.class);
    private final ObjectMapper objectMapper;
    private final Map<String, Class<? extends IdentifiableMessage<?>>> classIdToClass;
    private final Map<Class<? extends IdentifiableMessage<?>>, List<CrudQueueListener<?, ?>>> classToCrudQueue;
    private final Map<Class<? extends IdentifiableMessage<?>>, List<OnQueueCreateListener>> msgClassToOnCreateListener;
    private final Map<Class<? extends IdentifiableMessage<?>>, List<OnQueueUpdateListener>> msgClassToOnUpdateListener;
    private final Map<Class<? extends IdentifiableMessage<?>>, List<OnQueueDeleteListener>> msgClassToOnDeleteListener;

    @Autowired
    public CrudMessageListenerAndDelegationService(ObjectMapper objectMapper, List<CrudQueueListener<?, ?>> crudQueueListeners, List<OnQueueCreateListener<?, ?>> onCreateListeners, List<OnQueueUpdateListener<?, ?>> onUpdateListeners, List<OnQueueDeleteListener<?, ?>> onDeleteListeners) {
        this.objectMapper = objectMapper;
        this.classIdToClass = crudQueueListeners.stream().collect(Collectors.toMap(crudQueueListener -> crudQueueListener.getMessageType().getName(), MessageTyped::getMessageType));
        this.classIdToClass.putAll(onCreateListeners.stream().collect(Collectors.toMap(crudQueueListener -> crudQueueListener.getMessageType().getName(), OnQueueCreateListener::getMessageType)));
        this.classIdToClass.putAll(onUpdateListeners.stream().collect(Collectors.toMap(crudQueueListener -> crudQueueListener.getMessageType().getName(), OnQueueUpdateListener::getMessageType)));
        this.classIdToClass.putAll(onDeleteListeners.stream().collect(Collectors.toMap(crudQueueListener -> crudQueueListener.getMessageType().getName(), OnQueueDeleteListener::getMessageType)));
        this.classToCrudQueue = crudQueueListeners.stream().collect(Collectors.groupingBy(MessageTyped::getMessageType));
        this.msgClassToOnCreateListener = onCreateListeners.stream().collect(Collectors.groupingBy(OnQueueCreateListener::getMessageType));
        this.msgClassToOnUpdateListener = onUpdateListeners.stream().collect(Collectors.groupingBy(OnQueueUpdateListener::getMessageType));
        this.msgClassToOnDeleteListener = onDeleteListeners.stream().collect(Collectors.groupingBy(OnQueueDeleteListener::getMessageType));
    }

    @Timed(value="autumn.messaging.rabbitmq.received", description="Number of messages received", extraTags={"routing-key", "in"})
    void handle(Message message, BiConsumer<Class<? extends IdentifiableMessage<?>>, IdentifiableMessage> msgClassAndMessage) {
        IdentifiableMessage identifiableMessage;
        String payload;
        String classId = (String)message.getMessageProperties().getHeader("__TypeId__");
        String consumerQueue = message.getMessageProperties().getConsumerQueue();
        String messageAction = consumerQueue.substring(consumerQueue.lastIndexOf("."));
        log.trace("Received {} request for {}", (Object)messageAction, (Object)classId);
        try {
            payload = new String(message.getBody(), message.getMessageProperties().getContentEncoding());
        }
        catch (UnsupportedEncodingException e) {
            log.error("UnsupportedEncodingExeption while decoding message: {}", (Object)e.getMessage());
            throw new RuntimeException("Failed to parse message body to String for classId: " + classId);
        }
        if (!this.classIdToClass.containsKey(classId)) {
            log.trace("Received a message, but no handler was registered in the context that can handle this message. Consider registering a class of OnQueueCreateListener<?, {}>, OnQueueUpdateListener<?, {}>, OnQueueDeleteListener<?, {}> or CrudQueueListener<?, {}> if you need direct access to the IdentifiableMessage instance.Message is ignored: {}.", new Object[]{classId, classId, classId, classId, payload});
            return;
        }
        Class<? extends IdentifiableMessage<?>> aClass = this.classIdToClass.get(classId);
        try {
            identifiableMessage = (IdentifiableMessage)this.objectMapper.readValue(payload, aClass);
        }
        catch (JsonProcessingException e) {
            log.error("JsonProcessingException while mapping message: {}", (Object)e.getMessage());
            throw new IllegalStateException("Failed to deserialize message body into class" + aClass, e);
        }
        msgClassAndMessage.accept(aClass, identifiableMessage);
    }

    @Timed(value="autumn.messaging.rabbitmq.received.bulk", description="Number of messages received", extraTags={"routing-key", "in"})
    public void handleList(List<Message> messages, BiConsumer<Class<? extends IdentifiableMessage<?>>, List<IdentifiableMessage<?>>> msgClassAndMessage) {
        if (CollectionUtils.isEmpty(messages)) {
            log.warn("handleList called with an empty message list");
            return;
        }
        Message message = messages.get(0);
        String classId = (String)message.getMessageProperties().getHeader("__TypeId__");
        String consumerQueue = message.getMessageProperties().getConsumerQueue();
        String messageAction = consumerQueue.substring(consumerQueue.lastIndexOf("."));
        log.trace("Received batch of {} {} requests for {}", new Object[]{messages.size(), messageAction, classId});
        if (!this.classIdToClass.containsKey(classId)) {
            log.trace("Received a batch of messages, but no handler was registered in the context that can handle this message. Consider registering a class of OnQueueBatchCreateListener<?, {}>, OnQueueBatchUpdateListener<?, {}>, OnQueueBatchDeleteListener<?, {}> or CrudQueueListener<?, {}> if you need direct access to the IdentifiableMessage instance.Messages are ignored: {}.", new Object[]{classId, classId, classId, classId, messages});
            return;
        }
        Class<? extends IdentifiableMessage<?>> aClass = this.classIdToClass.get(classId);
        ArrayList<IdentifiableMessage> identifiableMessages = new ArrayList<IdentifiableMessage>();
        for (Message current : messages) {
            try {
                identifiableMessages.add((IdentifiableMessage)this.objectMapper.readValue(new String(current.getBody(), current.getMessageProperties().getContentEncoding()), aClass));
            }
            catch (UnsupportedEncodingException e) {
                log.error("UnsupportedEncodingExeption while decoding message: {}", (Object)e.getMessage());
                throw new RuntimeException("Failed to parse message body to String for classId: " + classId);
            }
            catch (JsonProcessingException e) {
                log.error("JsonProcessingException while mapping message: {}", (Object)e.getMessage());
                throw new IllegalStateException("Failed to deserialize message body into class" + aClass, e);
            }
        }
        msgClassAndMessage.accept(aClass, identifiableMessages);
    }

    public void delegateToCrudQueueListeners(Class<? extends IdentifiableMessage<?>> aClass, IdentifiableMessage<?> identifiableMessage, BiConsumer<CrudQueueListener, IdentifiableMessage> crudQueueListenerConsumerMethod) {
        List<CrudQueueListener<?, ?>> crudQueueListeners = this.classToCrudQueue.get(aClass);
        if (CollectionUtils.isEmpty(crudQueueListeners)) {
            log.trace("No CrudQueueListener for message {}", (Object)aClass.getSimpleName());
            return;
        }
        crudQueueListeners.forEach(crudQueueListener -> crudQueueListenerConsumerMethod.accept((CrudQueueListener)crudQueueListener, (IdentifiableMessage)identifiableMessage));
    }

    public void delegateListToCrudQueueListeners(Class<? extends IdentifiableMessage<?>> aClass, List<IdentifiableMessage<?>> identifiableMessages, BiConsumer<CrudQueueBatchListener, List<IdentifiableMessage<?>>> crudQueueListenerConsumerMethod) {
        List<CrudQueueListener<?, ?>> crudQueueListeners = this.classToCrudQueue.get(aClass);
        if (CollectionUtils.isEmpty(crudQueueListeners)) {
            log.trace("No CrudQueueListener for message {}", (Object)aClass.getSimpleName());
            return;
        }
        crudQueueListeners.forEach(crudQueueListener -> crudQueueListenerConsumerMethod.accept((CrudQueueBatchListener)crudQueueListener, identifiableMessages));
    }

    public void delegateToOnCreateListeners(Class<? extends IdentifiableMessage<?>> aClass, IdentifiableMessage<?> identifiableMessage) {
        List<OnQueueCreateListener> onQueueCreateListeners = this.msgClassToOnCreateListener.get(aClass);
        if (CollectionUtils.isEmpty(onQueueCreateListeners)) {
            log.trace("No OnQueueCreateListener for message {}", (Object)aClass.getSimpleName());
            return;
        }
        onQueueCreateListeners.forEach(onCreateListener -> onCreateListener.onCreate(identifiableMessage.getPayload(), (Object)EventMetaData.builder().messageChainId(identifiableMessage.getMessageChainId()).build()));
    }

    public void delegateListToOnCreateListeners(Class<? extends IdentifiableMessage<?>> aClass, List<IdentifiableMessage<?>> identifiableMessages) {
        List<OnQueueCreateListener> onQueueCreateListeners = this.msgClassToOnCreateListener.get(aClass);
        if (CollectionUtils.isEmpty(onQueueCreateListeners)) {
            log.trace("No OnQueueCreateListener for message {}", (Object)aClass.getSimpleName());
            return;
        }
        onQueueCreateListeners.forEach(onCreateListener -> {
            if (onCreateListener instanceof OnQueueBatchCreateListener) {
                ((OnQueueBatchCreateListener)onCreateListener).onCreate(identifiableMessages.stream().map(GenericIdentifiableMessage::getPayload).collect(Collectors.toList()), (Object)EventMetaData.builder().messageChainId(((IdentifiableMessage)identifiableMessages.get(0)).getMessageChainId()).build());
            } else {
                for (IdentifiableMessage identifiableMessage : identifiableMessages) {
                    onCreateListener.onCreate(identifiableMessage.getPayload(), (Object)EventMetaData.builder().messageChainId(identifiableMessage.getMessageChainId()).build());
                }
            }
        });
    }

    protected void delegateToOnUpdateListeners(Class<? extends IdentifiableMessage<?>> aClass, IdentifiableMessage<?> identifiableMessage) {
        List<OnQueueUpdateListener> onQueueUpdateListeners = this.msgClassToOnUpdateListener.get(aClass);
        if (CollectionUtils.isEmpty(onQueueUpdateListeners)) {
            log.trace("No OnQueueUpdateListener for message {}", (Object)aClass.getSimpleName());
            return;
        }
        onQueueUpdateListeners.forEach(onUpdateListener -> onUpdateListener.onUpdate(identifiableMessage.getPayload(), (Object)EventMetaData.builder().messageChainId(identifiableMessage.getMessageChainId()).build()));
    }

    public void delegateListToOnUpdateListeners(Class<? extends IdentifiableMessage<?>> aClass, List<IdentifiableMessage<?>> identifiableMessages) {
        List<OnQueueUpdateListener> onQueueUpdateListeners = this.msgClassToOnUpdateListener.get(aClass);
        if (CollectionUtils.isEmpty(onQueueUpdateListeners)) {
            log.trace("No OnQueueUpdateListener for message {}", (Object)aClass.getSimpleName());
            return;
        }
        onQueueUpdateListeners.forEach(onUpdateListener -> {
            if (onUpdateListener instanceof OnQueueBatchUpdateListener) {
                ((OnQueueBatchUpdateListener)onUpdateListener).onUpdate(identifiableMessages.stream().map(GenericIdentifiableMessage::getPayload).collect(Collectors.toList()), (Object)EventMetaData.builder().messageChainId(((IdentifiableMessage)identifiableMessages.get(0)).getMessageChainId()).build());
            } else {
                for (IdentifiableMessage identifiableMessage : identifiableMessages) {
                    onUpdateListener.onUpdate(identifiableMessage.getPayload(), (Object)EventMetaData.builder().messageChainId(identifiableMessage.getMessageChainId()).build());
                }
            }
        });
    }

    protected void delegateToOnDeleteListeners(Class<? extends IdentifiableMessage<?>> aClass, IdentifiableMessage<?> identifiableMessage) {
        List<OnQueueDeleteListener> onQueueDeleteListeners = this.msgClassToOnDeleteListener.get(aClass);
        if (CollectionUtils.isEmpty(onQueueDeleteListeners)) {
            log.trace("No OnQueueDeleteListener for message {}", (Object)aClass.getSimpleName());
            return;
        }
        onQueueDeleteListeners.forEach(onDeleteListener -> onDeleteListener.onDelete(identifiableMessage.getPayload(), (Object)EventMetaData.builder().messageChainId(identifiableMessage.getMessageChainId()).build()));
    }

    public void delegateListToOnDeleteListeners(Class<? extends IdentifiableMessage<?>> aClass, List<IdentifiableMessage<?>> identifiableMessages) {
        List<OnQueueDeleteListener> onQueueDeleteListeners = this.msgClassToOnDeleteListener.get(aClass);
        if (CollectionUtils.isEmpty(onQueueDeleteListeners)) {
            log.trace("No OnQueueDeleteListener for message {}", (Object)aClass.getSimpleName());
            return;
        }
        onQueueDeleteListeners.forEach(onDeleteListener -> {
            if (onDeleteListener instanceof OnQueueBatchDeleteListener) {
                ((OnQueueBatchDeleteListener)onDeleteListener).onDelete(identifiableMessages.stream().map(GenericIdentifiableMessage::getPayload).collect(Collectors.toList()), (Object)EventMetaData.builder().messageChainId(((IdentifiableMessage)identifiableMessages.get(0)).getMessageChainId()).build());
            } else {
                for (IdentifiableMessage identifiableMessage : identifiableMessages) {
                    onDeleteListener.onDelete(identifiableMessage.getPayload(), (Object)EventMetaData.builder().messageChainId(identifiableMessage.getMessageChainId()).build());
                }
            }
        });
    }

    @RabbitListener(queues={"${autumn.service.name}.in.create"})
    @Timed(value="autumn.messaging.rabbitmq.received.create", description="Number of create messages received", extraTags={"routing-key", "create"})
    void handleCreate(Message message) {
        this.handle(message, (aClass, identifiableMessage) -> {
            this.delegateToCrudQueueListeners((Class<? extends IdentifiableMessage<?>>)aClass, (IdentifiableMessage<?>)identifiableMessage, CrudQueueListener::handleCreate);
            this.delegateToOnCreateListeners((Class<? extends IdentifiableMessage<?>>)aClass, (IdentifiableMessage<?>)identifiableMessage);
        });
    }

    @RabbitListener(queues={"${autumn.service.name}.in.update"})
    @Timed(value="autumn.messaging.rabbitmq.received.update", description="Number of update messages received", extraTags={"routing-key", "update"})
    void handleUpdate(Message message) {
        this.handle(message, (aClass, identifiableMessage) -> {
            this.delegateToCrudQueueListeners((Class<? extends IdentifiableMessage<?>>)aClass, (IdentifiableMessage<?>)identifiableMessage, CrudQueueListener::handleUpdate);
            this.delegateToOnUpdateListeners((Class<? extends IdentifiableMessage<?>>)aClass, (IdentifiableMessage<?>)identifiableMessage);
        });
    }

    @RabbitListener(queues={"${autumn.service.name}.in.delete"})
    @Timed(value="autumn.messaging.rabbitmq.received.delete", description="Number of delete messages received", extraTags={"routing-key", "delete"})
    void handleDelete(Message message) {
        this.handle(message, (aClass, identifiableMessage) -> {
            this.delegateToCrudQueueListeners((Class<? extends IdentifiableMessage<?>>)aClass, (IdentifiableMessage<?>)identifiableMessage, CrudQueueListener::handleDelete);
            this.delegateToOnDeleteListeners((Class<? extends IdentifiableMessage<?>>)aClass, (IdentifiableMessage<?>)identifiableMessage);
        });
    }
}

