/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.rabbit.client.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.autumnframework.service.liveness.rabbit.LivenessRabbitConfiguration;
import org.autumnframework.service.queue.api.QueueApiConfiguration;
import org.autumnframework.service.queue.api.QueueApiProperties;
import org.autumnframework.service.queue.api.client.listener.CrudQueueListener;
import org.autumnframework.service.queue.api.client.listener.OnQueueCreateListener;
import org.autumnframework.service.queue.api.client.listener.OnQueueDeleteListener;
import org.autumnframework.service.queue.api.client.listener.OnQueueUpdateListener;
import org.autumnframework.service.rabbit.api.properties.RabbitMQApiProperties;
import org.autumnframework.service.rabbit.client.config.MQJsonConfig;
import org.autumnframework.service.rabbit.client.listener.CrudMessageListenerAndDelegationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Declarables;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

@Configuration
@EnableRabbit
@Import(value={QueueApiConfiguration.class, MQJsonConfig.class, LivenessRabbitConfiguration.class})
@PropertySources(value={@PropertySource(value={"classpath:service.properties"})})
public class RabbitClientConfig {
    private static final Logger log = LoggerFactory.getLogger(RabbitClientConfig.class);
    private static final Map<String, Object> QUEUE_ARGS = new HashMap<String, Object>();

    @Bean
    public CrudMessageListenerAndDelegationService listenerDelegation(ObjectMapper objectMapper, List<CrudQueueListener<?, ?>> crudQueueListeners, List<OnQueueCreateListener<?, ?>> onCreateListeners, List<OnQueueUpdateListener<?, ?>> onUpdateListeners, List<OnQueueDeleteListener<?, ?>> onDeleteListeners) {
        return new CrudMessageListenerAndDelegationService(objectMapper, crudQueueListeners, onCreateListeners, onUpdateListeners, onDeleteListeners);
    }

    @Bean
    public Declarables providerBindings(@Autowired QueueApiProperties queueApiProperties, @Autowired RabbitMQApiProperties rabbitMQApiProperties) {
        log.trace("creating client bindings");
        ArrayList<Object> declarables = new ArrayList<Object>();
        TopicExchange inExchange = new TopicExchange(rabbitMQApiProperties.getInExchangeName());
        declarables.add(inExchange);
        Queue inCreateQueue = new Queue(rabbitMQApiProperties.getInCreateQueue(), true, false, false, QUEUE_ARGS);
        declarables.add(inCreateQueue);
        declarables.add(BindingBuilder.bind((Queue)inCreateQueue).to(inExchange).with(RabbitMQApiProperties.getAllCreateKey()));
        Queue inUpdateQueue = new Queue(rabbitMQApiProperties.getInUpdateQueue(), true, false, false, QUEUE_ARGS);
        declarables.add(inUpdateQueue);
        declarables.add(BindingBuilder.bind((Queue)inUpdateQueue).to(inExchange).with(RabbitMQApiProperties.getAllUpdateKey()));
        Queue inDeleteQueue = new Queue(rabbitMQApiProperties.getInDeleteQueue(), true, false, false, QUEUE_ARGS);
        declarables.add(inDeleteQueue);
        declarables.add(BindingBuilder.bind((Queue)inDeleteQueue).to(inExchange).with(RabbitMQApiProperties.getAllDeleteKey()));
        if (queueApiProperties.getSubscribeTo() != null && !queueApiProperties.getSubscribeTo().isEmpty()) {
            queueApiProperties.getSubscribeTo().forEach(service -> {
                TopicExchange serviceExchange = new TopicExchange(RabbitMQApiProperties.getOutExchangeName((String)service));
                declarables.add(serviceExchange);
                declarables.add(BindingBuilder.bind((Exchange)inExchange).to(serviceExchange).with(RabbitMQApiProperties.getAllServiceKey((String)service)));
            });
        }
        return new Declarables(declarables);
    }

    static {
        QUEUE_ARGS.put("x-queue-type", "quorum");
    }
}

