/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.rabbit.client.listener;

import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;

/**
 * @deprecated please use {@link org.autumnframework.service.queue.api.client.listener.OnQueueDeleteListener}
 * @author Timon Veenstra
 */
@Slf4j
@RabbitListener(queues = {"${autumn.name}.in.delete"})
@Deprecated
public abstract class DeleteListener {

    /**
     * 
     */
    public DeleteListener() {
        log.warn("Please dont use this class, it is not compatible with the CrudMessageListenerAndDelegationService");
        log.warn("Instead implement org.autumnframework.service.queue.api.client.listener.OnQueueDeleteListener and annotate with @Service");
    }

    /**
     * @param message
     */
    @RabbitHandler(isDefault = true)
    void sink(Object message){
        log.trace("Message handled in the sink: {}",message);
    }
}
