/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.rabbit.batch.client.config;

import org.autumnframework.service.queue.api.QueueApiConfiguration;
import org.autumnframework.service.rabbit.batch.client.listener.BatchListenerComponent;
import org.autumnframework.service.rabbit.client.config.MQJsonConfig;
import org.autumnframework.service.rabbit.client.config.RabbitClientConfig;
import org.autumnframework.service.rabbit.client.listener.CrudMessageListenerAndDelegationService;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

@Configuration
@EnableRabbit
@Import(value={QueueApiConfiguration.class, MQJsonConfig.class, RabbitClientConfig.class})
@PropertySources(value={@PropertySource(value={"classpath:service.properties"})})
public class RabbitBatchClientConfig {
    @Bean
    @ConditionalOnExpression(value="'${autumn.messaging.type:rabbitmq}' == 'rabbitmq' and ${autumn.messaging.batch-enabled:false}")
    public SimpleRabbitListenerContainerFactory consumerBatchContainerFactory(ConnectionFactory rabbitConnectionFactory, @Value(value="${autumn.service.name:no-service-name-set}") String serviceName, @Value(value="${autumn.messaging.batch-size:100}") Integer batchSize) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(rabbitConnectionFactory);
        factory.setConsumerTagStrategy(q -> serviceName + "." + q);
        factory.setBatchListener(true);
        factory.setBatchSize(batchSize);
        factory.setDeBatchingEnabled(Boolean.valueOf(true));
        factory.setConsumerBatchEnabled(true);
        return factory;
    }

    @Bean
    @ConditionalOnBean(name={"consumerBatchContainerFactory"})
    public BatchListenerComponent batchListenerComponent(CrudMessageListenerAndDelegationService bean) {
        return new BatchListenerComponent(bean);
    }
}

