/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.rabbit.api.properties;

import java.util.List;
import org.autumnframework.service.api.APIConfiguration;
import org.autumnframework.service.api.ServiceProperties;
import org.autumnframework.service.queue.api.QueueApiProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Import;

@Import(value={APIConfiguration.class})
@ConfigurationProperties(value="autumn.messaging.rabbitmq")
public class RabbitMQApiProperties {
    @Autowired
    private QueueApiProperties queueApiProperies;
    @Autowired
    private ServiceProperties serviceProperties;
    private Monitoring monitoring = new Monitoring();
    private static final String CREATE = "create";
    private static final String UPDATE = "update";
    private static final String DELETE = "delete";
    private static final String IN = "in";
    private static final String OUT = "out";
    private static final String ALL = "*";
    private static final String EXCHANGE = "%s.%s.exchange";
    private static final String QUEUE = "%s.%s.%s";
    private static final String KEY = "%s.%s";

    public static String getOutExchangeName(String name) {
        return String.format(EXCHANGE, name, OUT);
    }

    public String getOutExchangeName() {
        return String.format(EXCHANGE, this.serviceProperties.getName(), OUT);
    }

    public static String getInExchangeName(String name) {
        return String.format(EXCHANGE, name, IN);
    }

    public String getInExchangeName() {
        return String.format(EXCHANGE, this.serviceProperties.getName(), IN);
    }

    public static String getInCreateQueue(String name) {
        return String.format(QUEUE, name, IN, CREATE);
    }

    public String getInCreateQueue() {
        return String.format(QUEUE, this.serviceProperties.getName(), IN, CREATE);
    }

    public static String getInUpdateQueue(String name) {
        return String.format(QUEUE, name, IN, UPDATE);
    }

    public String getInUpdateQueue() {
        return String.format(QUEUE, this.serviceProperties.getName(), IN, UPDATE);
    }

    public static String getInDeleteQueue(String name) {
        return String.format(QUEUE, name, IN, DELETE);
    }

    public String getInDeleteQueue() {
        return String.format(QUEUE, this.serviceProperties.getName(), IN, DELETE);
    }

    public static String getCreateRoutingKey(String name) {
        return String.format(KEY, name, CREATE);
    }

    public String getCreateRoutingKey() {
        return String.format(KEY, this.serviceProperties.getName(), CREATE);
    }

    public static String getUpdateRoutingKey(String name) {
        return String.format(KEY, name, UPDATE);
    }

    public String getUpdateRoutingKey() {
        return String.format(KEY, this.serviceProperties.getName(), UPDATE);
    }

    public static String getDeleteRoutingKey(String name) {
        return String.format(KEY, name, DELETE);
    }

    public String getDeleteRoutingKey() {
        return String.format(KEY, this.serviceProperties.getName(), DELETE);
    }

    public static String getAllCreateKey() {
        return String.format(KEY, ALL, CREATE);
    }

    public static String getAllUpdateKey() {
        return String.format(KEY, ALL, UPDATE);
    }

    public static String getAllDeleteKey() {
        return String.format(KEY, ALL, DELETE);
    }

    public static String getAllServiceKey(String name) {
        return String.format(KEY, name, ALL);
    }

    public String getAllServiceKey() {
        return String.format(KEY, this.serviceProperties.getName(), ALL);
    }

    public QueueApiProperties getQueueApiProperies() {
        return this.queueApiProperies;
    }

    public ServiceProperties getServiceProperties() {
        return this.serviceProperties;
    }

    public Monitoring getMonitoring() {
        return this.monitoring;
    }

    public void setQueueApiProperies(QueueApiProperties queueApiProperies) {
        this.queueApiProperies = queueApiProperies;
    }

    public void setServiceProperties(ServiceProperties serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    public void setMonitoring(Monitoring monitoring) {
        this.monitoring = monitoring;
    }

    public static class Monitoring {
        private List<String> subscriptions;
        private Integer subscriptionMaxMessages = 1000000;

        public List<String> getSubscriptions() {
            return this.subscriptions;
        }

        public Integer getSubscriptionMaxMessages() {
            return this.subscriptionMaxMessages;
        }

        public void setSubscriptions(List<String> subscriptions) {
            this.subscriptions = subscriptions;
        }

        public void setSubscriptionMaxMessages(Integer subscriptionMaxMessages) {
            this.subscriptionMaxMessages = subscriptionMaxMessages;
        }
    }
}

