/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.rabbit.api.properties;

import java.util.List;

import org.autumnframework.service.api.APIConfiguration;
import org.autumnframework.service.api.ServiceProperties;
import org.autumnframework.service.queue.api.QueueApiProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Import;

import lombok.Getter;
import lombok.Setter;

/**
 *
 *
 * @author Timon Veenstra
 */
@Getter
@Setter
@Import(APIConfiguration.class)
@ConfigurationProperties("autumn.messaging.rabbitmq")
public class RabbitMQApiProperties {

    @Autowired
    private QueueApiProperties queueApiProperies;
    
    @Autowired
    private ServiceProperties serviceProperties;

    //TODO change to only monitoring.enabled and check for subscriptions starting with this autumn.service.name
    /**
     * 
     */
    @Getter
    @Setter
    public static class Monitoring {
        private List<String> subscriptions;
        private Integer subscriptionMaxMessages = 1000000;
    }
    private Monitoring monitoring = new Monitoring();


    private static final String CREATE = "create";
    private static final String UPDATE = "update";
    private static final String DELETE = "delete";
    private static final String IN = "in";
    private static final String OUT = "out";
    private static final String ALL = "*";

    private static final String EXCHANGE = "%s.%s.exchange";

    /**
     * @param name
     * @return
     */
    public static String getOutExchangeName(String name) {return String.format(EXCHANGE, name, OUT);}
    
    /**
     * @return
     */
    public String getOutExchangeName() {
        return String.format(EXCHANGE, serviceProperties.getName(), OUT);
    }

    /**
     * @param name
     * @return
     */
    public static String getInExchangeName(String name) {return String.format(EXCHANGE, name, IN);}
    
    /**
     * @return
     */
    public String getInExchangeName() {return String.format(EXCHANGE, serviceProperties.getName(), IN);}

    private static final String QUEUE = "%s.%s.%s";

    /**
     * @param name
     * @return
     */
    public static String getInCreateQueue(String name) {return String.format(QUEUE, name, IN, CREATE);}
    /**
     * @return
     */
    public String getInCreateQueue() {return String.format(QUEUE, serviceProperties.getName(), IN, CREATE);}

    /**
     * @param name
     * @return
     */
    public static String getInUpdateQueue(String name) {return String.format(QUEUE, name, IN, UPDATE);}
    /**
     * @return
     */
    public String getInUpdateQueue() {return String.format(QUEUE, serviceProperties.getName(), IN, UPDATE);}

    /**
     * @param name
     * @return
     */
    public static String getInDeleteQueue(String name) {return String.format(QUEUE, name, IN, DELETE);}
    /**
     * @return
     */
    public  String getInDeleteQueue() {return String.format(QUEUE, serviceProperties.getName(), IN, DELETE);}


    private static final String KEY = "%s.%s";

    /**
     * @param name
     * @return
     */
    public static String getCreateRoutingKey(String name) {return String.format(KEY, name, CREATE);}
    /**
     * @return
     */
    public String getCreateRoutingKey() {return String.format(KEY, serviceProperties.getName(), CREATE);}

    /**
     * @param name
     * @return
     */
    public static String getUpdateRoutingKey(String name) {return String.format(KEY, name, UPDATE);}
    /**
     * @return
     */
    public String getUpdateRoutingKey() {return String.format(KEY, serviceProperties.getName(), UPDATE);}

    /**
     * @param name
     * @return
     */
    public static String getDeleteRoutingKey(String name) {return String.format(KEY, name, DELETE);}
    /**
     * @return
     */
    public String getDeleteRoutingKey() {
        return String.format(KEY, serviceProperties.getName(), DELETE);
    }

    /**
     * @return
     */
    public static String getAllCreateKey(){return String.format(KEY,ALL,CREATE);}
    /**
     * @return
     */
    public static String getAllUpdateKey(){return String.format(KEY,ALL,UPDATE);}
    /**
     * @return
     */
    public static String getAllDeleteKey(){return String.format(KEY,ALL,DELETE);}

    /**
     * @param name
     * @return
     */
    public static String getAllServiceKey(String name) {return String.format(KEY, name, ALL);}
    /**
     * @return
     */
    public String getAllServiceKey() {
        return String.format(KEY, serviceProperties.getName(), ALL);
    }

}
