/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.queue.autoconfigure;

import org.autumnframework.service.pubsub.api.PubSubApiConfiguration;
import org.autumnframework.service.queue.api.QueueApiConfiguration;
import org.autumnframework.service.rabbit.api.RabbitMQApiConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={QueueApiConfiguration.class})
@ConditionalOnProperty(havingValue="true", name={"autumn.messaging.enabled"}, matchIfMissing=true)
public class QueueApiAutoConfiguration {

    @Import(value={RabbitMQApiConfiguration.class})
    @Configuration
    @ConditionalOnProperty(havingValue="rabbitmq", name={"autumn.messaging.type"}, matchIfMissing=true)
    public class RabbitMQApiConfigurationLoader {
    }

    @Import(value={PubSubApiConfiguration.class})
    @Configuration
    @ConditionalOnProperty(havingValue="pubsub", name={"autumn.messaging.type"})
    public class PubSubApiConfigurationLoader {
    }
}

