/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.queue.autoconfigure;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import org.autumnframework.service.pubsub.api.PubSubApiConfiguration;
import org.autumnframework.service.queue.api.QueueApiConfiguration;
import org.autumnframework.service.rabbit.api.RabbitMQApiConfiguration;

@Configuration
@Import(QueueApiConfiguration.class)
@ConditionalOnProperty(havingValue = "true", name = "autumn.messaging.enabled", matchIfMissing = true)
public class QueueApiAutoConfiguration {
    
    @Import(PubSubApiConfiguration.class)
    @Configuration
    @ConditionalOnProperty(havingValue = "pubsub", name = "autumn.messaging.type")
    public class PubSubApiConfigurationLoader {
        //
    }
    
    @Import(RabbitMQApiConfiguration.class)
    @Configuration
    @ConditionalOnProperty(havingValue = "rabbitmq", name = "autumn.messaging.type", matchIfMissing = true)
    public class RabbitMQApiConfigurationLoader {
        //
    }
}
