/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.graphql.scalars.impl;

import graphql.language.StringValue;
import graphql.language.Value;
import graphql.scalars.util.Kit;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.function.Function;

public class LocalDateTimeScalar {
    public static GraphQLScalarType INSTANCE;

    static {
        Coercing<LocalDateTime, String> coercing = new Coercing<LocalDateTime, String>(){

            public String serialize(Object input) throws CoercingSerializeException {
                LocalDateTime localDateTime;
                if (input instanceof LocalDateTime) {
                    localDateTime = (LocalDateTime)input;
                } else if (input instanceof ZonedDateTime) {
                    localDateTime = ((ZonedDateTime)input).toLocalDateTime();
                } else if (input instanceof String) {
                    localDateTime = this.parseLocalDateTime(input.toString(), CoercingSerializeException::new);
                } else {
                    throw new CoercingSerializeException("Expected something we can convert to 'java.time.LocalDateTime' but was '" + Kit.typeName((Object)input) + "'.");
                }
                try {
                    return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS").format(localDateTime);
                }
                catch (DateTimeException e) {
                    throw new CoercingSerializeException("Unable to turn TemporalAccessor into LocalDateTime because of : '" + e.getMessage() + "'.");
                }
            }

            public LocalDateTime parseValue(Object input) throws CoercingParseValueException {
                LocalDateTime localDateTime;
                if (input instanceof LocalDateTime) {
                    localDateTime = (LocalDateTime)input;
                } else if (input instanceof ZonedDateTime) {
                    localDateTime = ((ZonedDateTime)input).toLocalDateTime();
                } else if (input instanceof String) {
                    localDateTime = this.parseLocalDateTime(input.toString(), CoercingParseValueException::new);
                } else {
                    throw new CoercingParseValueException("Expected a 'String' but was '" + Kit.typeName((Object)input) + "'.");
                }
                return localDateTime;
            }

            public LocalDateTime parseLiteral(Object input) throws CoercingParseLiteralException {
                if (!(input instanceof StringValue)) {
                    throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + Kit.typeName((Object)input) + "'.");
                }
                return this.parseLocalDateTime(((StringValue)input).getValue(), CoercingParseLiteralException::new);
            }

            public Value<?> valueToLiteral(Object input) {
                String s = this.serialize(input);
                return StringValue.newStringValue((String)s).build();
            }

            private LocalDateTime parseLocalDateTime(String s, Function<String, RuntimeException> exceptionMaker) {
                try {
                    return LocalDateTime.parse(s, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                }
                catch (DateTimeParseException e) {
                    throw exceptionMaker.apply("Invalid ISO-8601 value : '" + s + "'. because of : '" + e.getMessage() + "'");
                }
            }
        };
        INSTANCE = GraphQLScalarType.newScalar().name("LocalDateTime").description("An ISO-8601 compliant DateTime Scalar").coercing((Coercing)coercing).build();
    }
}

