/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.graphql.scalars;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;

import graphql.scalars.ExtendedScalars;
import org.autumnframework.service.graphql.scalars.impl.LocalDateTimeScalar;

/**
 * 
 */
@Configuration
@ComponentScan
public class ScalarsGraphqlConfig {
    
    /**
     * @return
     */
    @Bean
    public RuntimeWiringConfigurer scalarsRuntimeWiringConfigurer() {
        return wiringBuilder -> wiringBuilder
                .scalar(ExtendedScalars.DateTime)
                .scalar(ExtendedScalars.GraphQLBigDecimal)
                .scalar(ExtendedScalars.Date)
                .scalar(ExtendedScalars.Time)
                .scalar(ExtendedScalars.Locale)
                .scalar(LocalDateTimeScalar.INSTANCE)
                // schema backwards compatibility with our 'old' naming
                .scalar(ExtendedScalars.newAliasedScalar("LocalDate").aliasedScalar(ExtendedScalars.Date).build());
    }
}
