/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.graphql.dataloader;

import graphql.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.autumnframework.service.api.dtos.Identifiable;
import org.autumnframework.service.api.services.elementary.ReadFindByIdsService;
import reactor.core.publisher.Mono;

public class FindByIdsDataLoader {
    public static <T extends Identifiable> Mono<Map<UUID, T>> findByIds(Set<UUID> ids, ReadFindByIdsService<T> service) {
        return FindByIdsDataLoader.findByIds(ids, service, t -> (UUID)t.getId());
    }

    public static <T extends Identifiable> Mono<Map<UUID, T>> findByIds(Set<UUID> ids, ReadFindByIdsService<T> service, Function<T, UUID> keyExtractor) {
        return FindByIdsDataLoader.findByKeys(ids, l -> service.findByIds(l), keyExtractor, s -> new ArrayList(s), Function.identity());
    }

    public static <T extends Identifiable> Mono<Map<UUID, T>> findByIds(Set<UUID> keys, Function<List<UUID>, Collection<T>> serviceMethod) {
        return FindByIdsDataLoader.findByKeys(keys, serviceMethod, t -> (UUID)t.getId(), s -> new ArrayList(s), Function.identity());
    }

    public static <T extends Identifiable, R> Mono<Map<R, T>> findByKeys(Set<R> keys, Function<List<R>, Collection<T>> serviceMethod, Function<T, R> keyExtractor) {
        return FindByIdsDataLoader.findByKeys(keys, serviceMethod, keyExtractor, s -> new ArrayList(s), Function.identity());
    }

    public static <T extends Identifiable, C extends Iterable<R>, R> Mono<Map<R, T>> findByKeys(Set<R> keys, Function<C, Collection<T>> serviceMethod, Function<T, R> keyExtractor, Function<Set<R>, C> methodArgumentCreator, Function<List<R>, C> listToMethodArgumentCreator) {
        if (CollectionUtils.isEmpty(keys)) {
            return Mono.empty();
        }
        ArrayList<T> result = new ArrayList<T>();
        if (keys.size() < 50) {
            return Mono.just(serviceMethod.apply((Iterable)methodArgumentCreator.apply(keys)).stream().collect(Collectors.toMap(rel -> keyExtractor.apply(rel), Function.identity())));
        }
        List lists = Lists.partition(new ArrayList<R>(keys), (int)50);
        for (List list : lists) {
            result.addAll(serviceMethod.apply((Iterable)listToMethodArgumentCreator.apply(list)));
        }
        return Mono.just(result.stream().collect(Collectors.toMap(rel -> keyExtractor.apply(rel), Function.identity())));
    }
}

