/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.api.http.impl.servlet;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.protobuf.ByteString;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.attribyte.api.http.DeleteRequestBuilder;
import org.attribyte.api.http.FormPostRequestBuilder;
import org.attribyte.api.http.GetRequestBuilder;
import org.attribyte.api.http.HeadRequestBuilder;
import org.attribyte.api.http.Header;
import org.attribyte.api.http.PostRequestBuilder;
import org.attribyte.api.http.PutRequestBuilder;
import org.attribyte.api.http.Request;
import org.attribyte.api.http.RequestBuilder;
import org.attribyte.api.http.Response;

public class Bridge {
    public static StringBuilder getRequestURL(Request request) {
        URI uri = request.getURI();
        String scheme = uri.getScheme();
        String authority = uri.getRawAuthority();
        String path = uri.getRawPath();
        StringBuilder buf = new StringBuilder();
        if (scheme != null) {
            buf.append(scheme);
            buf.append("://");
        }
        if (authority != null) {
            buf.append(authority);
        }
        if (path != null) {
            buf.append(path);
        }
        return buf;
    }

    public static String getRequestURI(Request request) {
        return request.getURI().getRawPath();
    }

    public static final Request fromServletRequest(HttpServletRequest request, int maxBodyBytes) throws IOException {
        RequestBuilder prb;
        HashMap headers = Maps.newHashMapWithExpectedSize((int)8);
        ArrayList valueList = Lists.newArrayListWithExpectedSize((int)2);
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            Enumeration headerValues = request.getHeaders(name);
            valueList.clear();
            while (headerValues.hasMoreElements()) {
                valueList.add((String)headerValues.nextElement());
            }
            if (valueList.size() == 1) {
                headers.put(name, new Header(name, (String)valueList.get(0)));
                continue;
            }
            headers.put(name, new Header(name, valueList.toArray(new String[valueList.size()])));
        }
        String queryString = request.getQueryString();
        String requestURL = Strings.isNullOrEmpty((String)queryString) ? request.getRequestURL().toString() : request.getRequestURL().append('?').append(queryString).toString();
        Map parameterMap = request.getParameterMap();
        Request.Method method = Request.Method.fromString(request.getMethod());
        switch (method) {
            case GET: {
                GetRequestBuilder grb = new GetRequestBuilder(requestURL, parameterMap);
                grb.addHeaders(headers);
                grb.addAttribute("remoteAddr", request.getRemoteAddr());
                return grb.create();
            }
            case HEAD: {
                HeadRequestBuilder hrb = new HeadRequestBuilder(requestURL, parameterMap);
                hrb.addHeaders(headers);
                hrb.addAttribute("remoteAddr", request.getRemoteAddr());
                return hrb.create();
            }
            case DELETE: {
                DeleteRequestBuilder drb = new DeleteRequestBuilder(requestURL, request.getParameterMap());
                drb.addHeaders(headers);
                drb.addAttribute("remoteAddr", request.getRemoteAddr());
                return drb.create();
            }
        }
        if (parameterMap != null && parameterMap.size() > 0) {
            FormPostRequestBuilder prb2 = new FormPostRequestBuilder(requestURL);
            prb2.addHeaders(headers);
            prb2.addParameters(request.getParameterMap());
            prb2.addAttribute("remoteAddr", request.getRemoteAddr());
            return prb2.create();
        }
        byte[] body = null;
        if (maxBodyBytes > 0) {
            try (ServletInputStream is = request.getInputStream();){
                body = Request.bodyFromInputStream((InputStream)is, maxBodyBytes);
            }
        } else {
            ByteStreams.toByteArray((InputStream)request.getInputStream());
        }
        if (method == Request.Method.POST) {
            prb = new PostRequestBuilder(requestURL, body);
            prb.addHeaders(headers);
            prb.addAttribute("remoteAddr", request.getRemoteAddr());
            return ((PostRequestBuilder)prb).create();
        }
        prb = new PutRequestBuilder(requestURL, body);
        prb.addHeaders(headers);
        prb.addAttribute("remoteAddr", request.getRemoteAddr());
        return ((PutRequestBuilder)prb).create();
    }

    public static final void sendServletResponse(Response response, HttpServletResponse servletResponse) throws IOException {
        servletResponse.setStatus(response.getStatusCode());
        Collection<Header> headers = response.getHeaders();
        for (Header header : headers) {
            String[] values;
            for (String value : values = header.getValues()) {
                servletResponse.setHeader(header.getName(), value);
            }
        }
        ByteString bodyString = response.getBody();
        if (bodyString != null) {
            try (BufferedOutputStream baos = new BufferedOutputStream((OutputStream)servletResponse.getOutputStream());){
                baos.write(bodyString.toByteArray());
            }
        }
    }
}

