/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.api.http.impl.commons;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.attribyte.api.InitializationException;
import org.attribyte.api.Logger;
import org.attribyte.api.http.Client;
import org.attribyte.api.http.ClientOptions;
import org.attribyte.api.http.Header;
import org.attribyte.api.http.Parameter;
import org.attribyte.api.http.Request;
import org.attribyte.api.http.RequestOptions;
import org.attribyte.api.http.Response;
import org.attribyte.api.http.ResponseBuilder;

public class Commons4Client
implements Client {
    private CloseableHttpClient httpClient;
    private RequestConfig defaultRequestConfig;
    private final AtomicBoolean isInit = new AtomicBoolean(false);

    public Commons4Client() {
    }

    private void initFromOptions(ClientOptions options) {
        if (options != ClientOptions.IMPLEMENTATION_DEFAULT) {
            HttpClientBuilder builder = HttpClients.custom();
            builder.setMaxConnTotal(options.maxConnectionsTotal);
            builder.setMaxConnPerRoute(options.maxConnectionsPerDestination);
            builder.setUserAgent(options.userAgent);
            if (options.proxyHost != null) {
                builder.setProxy(new HttpHost(options.proxyHost, options.proxyPort));
            }
            this.defaultRequestConfig = RequestConfig.custom().setConnectTimeout(options.connectionTimeoutMillis).setConnectionRequestTimeout(options.requestTimeoutMillis).setRedirectsEnabled(true).setMaxRedirects(5).setAuthenticationEnabled(false).setCircularRedirectsAllowed(false).setSocketTimeout(options.socketTimeoutMillis).build();
            builder.setDefaultRequestConfig(this.defaultRequestConfig);
            ConnectionConfig connectionConfig = ConnectionConfig.custom().setBufferSize(options.requestBufferSize > options.responseBufferSize ? options.requestBufferSize : options.responseBufferSize).build();
            builder.setDefaultConnectionConfig(connectionConfig);
            this.httpClient = builder.build();
        } else {
            this.defaultRequestConfig = RequestConfig.DEFAULT;
            this.httpClient = HttpClients.createDefault();
        }
    }

    public Commons4Client(ClientOptions options) {
        this.initFromOptions(options);
    }

    @Override
    public void init(String prefix, Properties props, Logger logger) throws InitializationException {
        if (this.isInit.compareAndSet(false, true)) {
            ClientOptions options = new ClientOptions(prefix, props);
            this.initFromOptions(options);
        }
    }

    @Override
    public Response send(Request request) throws IOException {
        return this.send(request, RequestOptions.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response send(Request request, RequestOptions options) throws IOException {
        HttpGet commonsRequest = null;
        switch (request.getMethod()) {
            case GET: {
                commonsRequest = new HttpGet(request.getURI());
                break;
            }
            case DELETE: {
                commonsRequest = new HttpDelete(request.getURI());
                break;
            }
            case HEAD: {
                commonsRequest = new HttpHead(request.getURI());
                break;
            }
            case POST: {
                HttpPost entityEnclosingRequest = new HttpPost(request.getURI());
                commonsRequest = entityEnclosingRequest;
                EntityBuilder entityBuilder = EntityBuilder.create();
                if (request.getBody() != null) {
                    entityBuilder.setBinary(request.getBody().toByteArray());
                } else {
                    Collection<Parameter> parameters = request.getParameters();
                    ArrayList nameValuePairs = Lists.newArrayListWithExpectedSize((int)parameters.size());
                    for (Parameter parameter : parameters) {
                        String[] values;
                        for (String value : values = parameter.getValues()) {
                            nameValuePairs.add(new BasicNameValuePair(parameter.getName(), value));
                        }
                    }
                }
                entityEnclosingRequest.setEntity(entityBuilder.build());
                break;
            }
            case PUT: {
                HttpPost entityEnclosingRequest = new HttpPut(request.getURI());
                commonsRequest = entityEnclosingRequest;
                EntityBuilder entityBuilder = EntityBuilder.create();
                if (request.getBody() != null) {
                    entityBuilder.setBinary(request.getBody().toByteArray());
                }
                entityEnclosingRequest.setEntity(entityBuilder.build());
                break;
            }
        }
        Collection<Header> headers = request.getHeaders();
        for (Header header : headers) {
            String[] values = header.getValues();
            for (String value : values) {
                commonsRequest.setHeader(header.getName(), value);
            }
        }
        ResponseBuilder builder = new ResponseBuilder();
        CloseableHttpResponse response = null;
        InputStream is = null;
        try {
            if (!options.followRedirects) {
                org.apache.http.Header[] localConfig = RequestConfig.copy((RequestConfig)this.defaultRequestConfig).setRedirectsEnabled(options.followRedirects).setMaxRedirects(options.followRedirects ? 5 : 0).build();
                HttpClientContext localContext = HttpClientContext.create();
                localContext.setRequestConfig((RequestConfig)localConfig);
                response = this.httpClient.execute((HttpUriRequest)commonsRequest, (HttpContext)localContext);
            } else {
                response = this.httpClient.execute((HttpUriRequest)commonsRequest);
            }
            builder.setStatusCode(response.getStatusLine().getStatusCode());
            for (org.apache.http.Header header : response.getAllHeaders()) {
                builder.addHeader(header.getName(), header.getValue());
            }
            HttpEntity entity = response.getEntity();
            if (entity != null && (is = entity.getContent()) != null) {
                builder.setBody(Request.bodyFromInputStream(is, options.maxResponseBytes));
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (response != null) {
                response.close();
            }
        }
        return builder.create();
    }

    @Override
    public void shutdown() {
        try {
            this.httpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

