/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.api.http.impl.commons;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.attribyte.api.InitializationException;
import org.attribyte.api.Logger;
import org.attribyte.api.http.Client;
import org.attribyte.api.http.ClientOptions;
import org.attribyte.api.http.Header;
import org.attribyte.api.http.Parameter;
import org.attribyte.api.http.Request;
import org.attribyte.api.http.RequestOptions;
import org.attribyte.api.http.Response;
import org.attribyte.api.http.ResponseBuilder;

public class Commons3Client
implements Client {
    private HttpClient httpClient;
    private MultiThreadedHttpConnectionManager connectionManager;
    private String userAgent;
    private final AtomicBoolean isInit = new AtomicBoolean(false);

    public Commons3Client() {
    }

    public Commons3Client(ClientOptions options) {
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        this.connectionManager.setParams(this.fromOptions(options));
        this.httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
        HostConfiguration hostConfig = new HostConfiguration();
        if (options.proxyHost != null) {
            hostConfig.setProxy(options.proxyHost, options.proxyPort);
        }
        this.httpClient.setHostConfiguration(hostConfig);
        this.userAgent = options.userAgent;
    }

    @Override
    public synchronized void init(String prefix, Properties props, Logger logger) throws InitializationException {
        if (this.isInit.compareAndSet(false, true)) {
            ClientOptions options = new ClientOptions(prefix, props);
            this.connectionManager = new MultiThreadedHttpConnectionManager();
            this.connectionManager.setParams(this.fromOptions(options));
            this.httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
            HostConfiguration hostConfig = new HostConfiguration();
            if (options.proxyHost != null) {
                hostConfig.setProxy(options.proxyHost, options.proxyPort);
            }
            this.httpClient.setHostConfiguration(hostConfig);
            this.userAgent = options.userAgent;
        }
    }

    private HttpConnectionManagerParams fromOptions(ClientOptions options) {
        HttpConnectionManagerParams connectionParams = new HttpConnectionManagerParams();
        if (options != ClientOptions.IMPLEMENTATION_DEFAULT) {
            connectionParams.setConnectionTimeout(options.connectionTimeoutMillis);
            connectionParams.setSoTimeout(options.socketTimeoutMillis);
            connectionParams.setDefaultMaxConnectionsPerHost(options.maxConnectionsPerDestination);
            connectionParams.setMaxTotalConnections(options.maxConnectionsTotal);
            connectionParams.setSendBufferSize(options.requestBufferSize);
            connectionParams.setReceiveBufferSize(options.responseBufferSize);
        }
        return connectionParams;
    }

    @Override
    public Response send(Request request) throws IOException {
        return this.send(request, RequestOptions.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response send(Request request, RequestOptions options) throws IOException {
        GetMethod method = null;
        switch (request.getMethod()) {
            case GET: {
                method = new GetMethod(request.getURI().toString());
                method.setFollowRedirects(options.followRedirects);
                break;
            }
            case DELETE: {
                method = new DeleteMethod(request.getURI().toString());
                break;
            }
            case HEAD: {
                method = new HeadMethod(request.getURI().toString());
                method.setFollowRedirects(options.followRedirects);
                break;
            }
            case POST: {
                ByteArrayRequestEntity requestEntity;
                method = new PostMethod(request.getURI().toString());
                if (request.getBody() != null) {
                    requestEntity = new ByteArrayRequestEntity(request.getBody().toByteArray());
                    ((EntityEnclosingMethod)method).setRequestEntity((RequestEntity)requestEntity);
                    break;
                }
                PostMethod postMethod = (PostMethod)method;
                Collection<Parameter> parameters = request.getParameters();
                Iterator iterator = parameters.iterator();
                while (iterator.hasNext()) {
                    String[] values;
                    Parameter parameter = (Parameter)iterator.next();
                    String[] stringArray = values = parameter.getValues();
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String value = stringArray[i];
                        postMethod.addParameter(parameter.getName(), value);
                    }
                }
                break;
            }
            case PUT: {
                method = new PutMethod(request.getURI().toString());
                if (request.getBody() == null) break;
                ByteArrayRequestEntity requestEntity = new ByteArrayRequestEntity(request.getBody().toByteArray());
                ((EntityEnclosingMethod)method).setRequestEntity((RequestEntity)requestEntity);
            }
        }
        if (this.userAgent != null && Strings.isNullOrEmpty((String)request.getHeaderValue("User-Agent"))) {
            method.setRequestHeader("User-Agent", this.userAgent);
        }
        Collection<Header> headers = request.getHeaders();
        for (Header header : headers) {
            String[] values;
            for (String value : values = header.getValues()) {
                method.setRequestHeader(header.getName(), value);
            }
        }
        InputStream is = null;
        try {
            int responseCode = this.httpClient.executeMethod((HttpMethod)method);
            is = method.getResponseBodyAsStream();
            if (is != null) {
                byte[] body = Request.bodyFromInputStream(is, options.maxResponseBytes);
                ResponseBuilder builder = new ResponseBuilder();
                builder.setStatusCode(responseCode);
                builder.addHeaders(this.getMap((NameValuePair[])method.getResponseHeaders()));
                Response response = builder.setBody((byte[])(body.length != 0 ? body : null)).create();
                return response;
            }
            ResponseBuilder builder = new ResponseBuilder();
            builder.setStatusCode(responseCode);
            builder.addHeaders(this.getMap((NameValuePair[])method.getResponseHeaders()));
            Response response = builder.create();
            return response;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            method.releaseConnection();
        }
    }

    private Map<String, Object> getMap(NameValuePair[] pairs) {
        if (pairs == null || pairs.length == 0) {
            return Collections.emptyMap();
        }
        HashMap parameterMap = Maps.newHashMapWithExpectedSize((int)8);
        for (NameValuePair pair : pairs) {
            Object o = parameterMap.get(pair.getName());
            if (o == null) {
                parameterMap.put(pair.getName(), pair.getValue());
                continue;
            }
            if (o instanceof List) {
                ((List)o).add(pair.getValue());
                continue;
            }
            ArrayList vlist = Lists.newArrayListWithExpectedSize((int)2);
            vlist.add(pair.getValue());
            parameterMap.put(pair.getName(), vlist);
        }
        return parameterMap;
    }

    @Override
    public void shutdown() {
        this.connectionManager.shutdown();
    }
}

