/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.api.http;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.attribyte.api.http.Header;
import org.attribyte.api.http.NamedValues;

public class Response {
    public final int statusCode;
    public final ImmutableMap<String, Header> headers;
    public final ImmutableMap<String, Object> attributes;

    public Response(int statusCode, Map<?, ?> headers) {
        this.statusCode = statusCode;
        this.headers = Header.createImmutableMap(headers);
        this.attributes = ImmutableMap.of();
    }

    public Response(int statusCode, Map<?, ?> headers, Map<String, Object> attributes) {
        this.statusCode = statusCode;
        this.headers = Header.createImmutableMap(headers);
        this.attributes = attributes != null ? ImmutableMap.copyOf(attributes) : ImmutableMap.of();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public ByteString getBody() throws IOException {
        return null;
    }

    public String getHeaderValue(String name) {
        Header h = (Header)this.headers.get((Object)name.toLowerCase());
        return h == null ? null : h.getValue();
    }

    public String[] getHeaderValues(String name) {
        Header h = (Header)this.headers.get((Object)name.toLowerCase());
        return h == null ? null : h.getValues();
    }

    public ImmutableList<String> getHeaderValueList(String name) {
        Header h = (Header)this.headers.get((Object)name);
        if (h != null) {
            return h.getValueList();
        }
        h = (Header)this.headers.get((Object)name.toLowerCase());
        return h == null ? ImmutableList.of() : h.getValueList();
    }

    public String getContentType() {
        return this.getHeaderValue("Content-Type");
    }

    public String getCharset(String defaultCharset) {
        return Header.getCharset(this.getContentType(), defaultCharset);
    }

    public Collection<Header> getHeaders() {
        return this.headers.values();
    }

    public Object getAttribute(String name) {
        return this.attributes == null ? null : this.attributes.get((Object)name);
    }

    public String toString() {
        String newline = System.getProperty("line.separator");
        StringBuilder buf = new StringBuilder();
        buf.append(this.statusCode);
        buf.append(newline).append(newline);
        buf.append("Headers: ").append(newline);
        if (this.headers != null) {
            for (Header header : this.headers.values()) {
                buf.append(header.getName()).append(": ").append(NamedValues.valueJoiner.join(header.getValueList()));
                buf.append(newline);
            }
        } else {
            buf.append(newline);
        }
        buf.append(newline);
        buf.append("Attributes: ").append(newline);
        if (this.attributes != null) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                buf.append((String)entry.getKey()).append(": ").append(entry.getValue().toString());
                buf.append(newline);
            }
        } else {
            buf.append(newline);
        }
        buf.append(newline);
        buf.append("Body: ").append(newline);
        try {
            ByteString body = this.getBody();
            if (body != null) {
                buf.append(new String(body.toByteArray(), Charsets.UTF_8));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return buf.toString();
    }

    public static class Code {
        public static final int OK = 200;
        public static final int ACCEPTED = 202;
        public static final int NO_CONTENT = 204;
        public static final int BAD_REQUEST = 400;
        public static final int UNAUTHORIZED = 401;
        public static final int FORBIDDEN = 403;
        public static final int NOT_FOUND = 404;
        public static final int SERVER_ERROR = 500;
        public static final int SERVER_UNAVAILABLE = 503;

        public static final boolean isOK(int code) {
            return code > 199 && code < 300;
        }
    }
}

