/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.api.http;

import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import org.attribyte.api.InvalidURIException;
import org.attribyte.api.http.Parameter;
import org.attribyte.api.http.RequestBuilder;

public abstract class RequestBuilderWithParameters
extends RequestBuilder {
    final Map<String, Parameter> parameters;
    final boolean caseSensitiveParameters;

    protected RequestBuilderWithParameters(String uri, Map parameters) throws InvalidURIException {
        super(uri);
        this.caseSensitiveParameters = false;
        this.parameters = Parameter.createMap(parameters);
    }

    protected RequestBuilderWithParameters(String uri, boolean caseSensitiveParameters) throws InvalidURIException {
        super(uri);
        this.caseSensitiveParameters = caseSensitiveParameters;
        this.parameters = Maps.newHashMapWithExpectedSize((int)8);
    }

    protected RequestBuilderWithParameters(URI uri, boolean caseSensitiveParameters) {
        super(uri);
        this.caseSensitiveParameters = caseSensitiveParameters;
        this.parameters = Maps.newHashMapWithExpectedSize((int)8);
    }
}

