/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.api.http;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.protobuf.ByteString;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.attribyte.api.DataLimitException;
import org.attribyte.api.InvalidURIException;
import org.attribyte.api.http.Header;
import org.attribyte.api.http.Parameter;

public final class Request {
    public static final String FORM_ENCODED_CONTENT_TYPE = "application/x-www-form-urlencoded";
    public static final String REMOTE_ADDR = "remoteAddr";
    public final Method method;
    public final URI uri;
    public final ImmutableMap<String, Header> headers;
    public final ImmutableMap<String, Parameter> parameters;
    public final ImmutableMap<String, Object> attributes;
    public final ByteString body;
    public final boolean caseSensitiveParameters;

    Request(Method method, URI uri, Map<String, Header> headers, Map<String, Parameter> parameters, boolean caseSensitiveParameters, byte[] body, Map<String, Object> attributes) {
        this.method = method;
        this.uri = uri;
        this.headers = Header.createImmutableMap(headers);
        this.parameters = Parameter.createImmutableMap(parameters);
        this.caseSensitiveParameters = caseSensitiveParameters;
        this.body = body != null ? ByteString.copyFrom((byte[])body) : null;
        this.attributes = attributes != null ? ImmutableMap.copyOf(attributes) : ImmutableMap.of();
    }

    Request(Method method, URI uri, Map<String, Header> headers, Map<String, Parameter> parameters, boolean caseSensitiveParameters, ByteString body, Map<String, Object> attributes) {
        this.method = method;
        this.uri = uri;
        this.headers = Header.createImmutableMap(headers);
        this.parameters = Parameter.createImmutableMap(parameters);
        this.caseSensitiveParameters = caseSensitiveParameters;
        this.body = body;
        this.attributes = attributes != null ? ImmutableMap.copyOf(attributes) : ImmutableMap.of();
    }

    public Method getMethod() {
        return this.method;
    }

    public String getQueryString() {
        return this.uri.getQuery();
    }

    public String getRawQueryString() {
        return this.uri.getRawQuery();
    }

    public String getRequestPath() {
        String path = this.uri.getPath();
        return path != null ? path : "/";
    }

    public static final String getRequestPath(String uri) throws InvalidURIException {
        try {
            String path = new URI(uri).getPath();
            return path != null ? path : "/";
        }
        catch (URISyntaxException use) {
            throw new InvalidURIException(use);
        }
    }

    public static final String getHostURL(String uri) throws InvalidURIException {
        try {
            URI _uri = new URI(uri);
            String scheme = _uri.getScheme();
            String authority = _uri.getRawAuthority();
            StringBuilder buf = new StringBuilder();
            if (scheme != null) {
                buf.append(scheme).append("://");
            }
            if (authority != null) {
                buf.append(authority);
            }
            return buf.toString();
        }
        catch (URISyntaxException use) {
            throw new InvalidURIException(use);
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public String getHeaderValue(String name) {
        Header h = (Header)this.headers.get((Object)name);
        if (h != null) {
            return h.getValue();
        }
        h = (Header)this.headers.get((Object)name.toLowerCase());
        return h == null ? null : h.getValue();
    }

    public String[] getHeaderValues(String name) {
        Header h = (Header)this.headers.get((Object)name);
        if (h != null) {
            return h.getValues();
        }
        h = (Header)this.headers.get((Object)name.toLowerCase());
        return h == null ? null : h.getValues();
    }

    public ImmutableList<String> getHeaderValueList(String name) {
        Header h = (Header)this.headers.get((Object)name);
        if (h != null) {
            return h.getValueList();
        }
        h = (Header)this.headers.get((Object)name.toLowerCase());
        return h == null ? ImmutableList.of() : h.getValueList();
    }

    public Header getHeader(String name) {
        Header h = (Header)this.headers.get((Object)name);
        if (h != null) {
            return h;
        }
        return (Header)this.headers.get((Object)name.toLowerCase());
    }

    public String getParameterValue(String name) {
        Parameter p = (Parameter)this.parameters.get((Object)(this.caseSensitiveParameters ? name : name.toLowerCase()));
        return p == null ? null : p.getValue();
    }

    public String[] getParameterValues(String name) {
        Parameter p = (Parameter)this.parameters.get((Object)(this.caseSensitiveParameters ? name : name.toLowerCase()));
        return p == null ? null : p.getValues();
    }

    public ImmutableList<String> getParameterValueList(String name) {
        Parameter p = (Parameter)this.parameters.get((Object)(this.caseSensitiveParameters ? name : name.toLowerCase()));
        return p == null ? ImmutableList.of() : p.getValueList();
    }

    public Collection<Header> getHeaders() {
        return this.headers.values();
    }

    public Collection<Parameter> getParameters() {
        return this.parameters.values();
    }

    public ByteString getBody() {
        return this.body;
    }

    public String getContentType() {
        return this.getHeaderValue("Content-Type");
    }

    public String getCharset(String defaultCharset) {
        return Header.getCharset(this.getContentType(), defaultCharset);
    }

    public boolean isFormEncoded() {
        if (this.method == Method.POST && this.parameters.size() > 0) {
            return true;
        }
        String contentType = this.getContentType();
        if (contentType == null) {
            return false;
        }
        contentType = contentType.toLowerCase().trim();
        return contentType.startsWith(FORM_ENCODED_CONTENT_TYPE);
    }

    public String getRemoteAddr() {
        return this.attributes == null ? null : (String)this.attributes.get((Object)REMOTE_ADDR);
    }

    public String getServerName() {
        String host = this.getHeaderValue("Host");
        if (Strings.isNullOrEmpty((String)host)) {
            return null;
        }
        int index = host.indexOf(58);
        if (index == -1) {
            return host;
        }
        return host.substring(0, index);
    }

    public List<String> getPathComponents() {
        String path = this.uri.getPath();
        if (path.length() < 2) {
            return Collections.emptyList();
        }
        ArrayList components = Lists.newArrayListWithExpectedSize((int)8);
        StringTokenizer tok = new StringTokenizer(path, "/");
        if (tok.hasMoreTokens()) {
            tok.nextToken();
        }
        while (tok.hasMoreTokens()) {
            String currComponent = tok.nextToken().trim();
            if (currComponent.length() <= 0) continue;
            components.add(currComponent);
        }
        return components;
    }

    public static final List<String> getPathComponents(String uri) throws InvalidURIException {
        String requestPath = Request.getRequestPath(uri);
        if (requestPath.length() < 2) {
            return Collections.emptyList();
        }
        requestPath = requestPath.substring(1);
        ArrayList components = Lists.newArrayListWithExpectedSize((int)8);
        StringTokenizer tok = new StringTokenizer(requestPath, "/");
        while (tok.hasMoreTokens()) {
            String currComponent = tok.nextToken().trim();
            if (currComponent.length() <= 0) continue;
            components.add(currComponent);
        }
        return components;
    }

    public Request addHeaders(Collection<Header> headers) {
        HashMap newHeaders = this.headers == null ? Maps.newHashMapWithExpectedSize((int)8) : Maps.newHashMap(this.headers);
        for (Header header : headers) {
            newHeaders.put(header.getName(), header);
        }
        return new Request(this.method, this.uri, (Map<String, Header>)newHeaders, (Map<String, Parameter>)this.parameters, this.caseSensitiveParameters, this.body, (Map<String, Object>)this.attributes);
    }

    public static final byte[] bodyFromInputStream(InputStream is, int maxBytesRead) throws IOException {
        InputStream cis = is instanceof BufferedInputStream ? ByteStreams.limit((InputStream)is, (long)maxBytesRead) : ByteStreams.limit((InputStream)new BufferedInputStream(is), (long)maxBytesRead);
        byte[] body = ByteStreams.toByteArray((InputStream)cis);
        if (body.length < maxBytesRead) {
            return body;
        }
        throw new DataLimitException("The size of the body exceeds the limit of " + maxBytesRead + " bytes");
    }

    public static final Map<String, Parameter> parseParameters(String queryString) {
        return Request.parseParameters(queryString, false);
    }

    public static final Map<String, Parameter> parseParametersPreserveNameCase(String queryString) {
        return Request.parseParameters(queryString, true);
    }

    public static final Map<String, Parameter> parseParameters(String queryString, boolean caseSensitiveNames) {
        if (queryString == null || queryString.length() == 0) {
            return Collections.emptyMap();
        }
        switch (queryString.charAt(0)) {
            case '&': 
            case '?': {
                queryString = queryString.substring(1);
            }
        }
        HashMap parameterMap = Maps.newHashMapWithExpectedSize((int)8);
        StringTokenizer tok = new StringTokenizer(queryString, "&");
        while (tok.hasMoreTokens()) {
            String value;
            String name;
            String nv = tok.nextToken();
            int index = nv.indexOf("=");
            if (index == -1 || index == nv.length() - 1) {
                name = nv;
                value = "";
            } else {
                name = nv.substring(index);
                value = nv.substring(index + 1);
            }
            String key = caseSensitiveNames ? name : name.toLowerCase();
            Parameter currParam = (Parameter)parameterMap.get(key);
            if (currParam == null) {
                parameterMap.put(key, new Parameter(name, value));
                continue;
            }
            parameterMap.put(key, currParam.addValue(value));
        }
        return parameterMap;
    }

    public String toString() {
        String newline = System.getProperty("line.separator");
        StringBuilder buf = new StringBuilder();
        buf.append(this.method != null ? this.method.toString() : "[null]");
        buf.append(" ");
        if (this.uri != null) {
            buf.append(this.uri.toString());
        }
        buf.append(newline).append(newline);
        buf.append("Headers: ").append(newline);
        if (this.headers != null) {
            for (Header header : this.headers.values()) {
                buf.append(header.toString());
                buf.append(newline);
            }
        } else {
            buf.append(newline);
        }
        buf.append(newline);
        buf.append("Parameters: ").append(newline);
        if (this.parameters != null) {
            for (Parameter parameter : this.parameters.values()) {
                buf.append(parameter.toString());
                buf.append(newline);
            }
        } else {
            buf.append(newline);
        }
        buf.append(newline);
        buf.append("Attributes: ").append(newline);
        if (this.attributes != null) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                buf.append((String)entry.getKey()).append(":").append(entry.getValue().toString());
                buf.append(newline);
            }
        } else {
            buf.append(newline);
        }
        buf.append(newline);
        buf.append("Body: ").append(newline);
        if (this.body != null) {
            try {
                String bodyStr = this.body.toString(Charsets.UTF_8.name());
                buf.append(bodyStr);
            }
            catch (UnsupportedEncodingException uee) {
                buf.append("[Encoding Unsupported]");
            }
        }
        return buf.toString();
    }

    public static enum Method {
        HEAD,
        GET,
        POST,
        PUT,
        DELETE;

        private static final ImmutableMap<String, Method> strMap;

        public static Method fromString(String str) {
            return (Method)((Object)strMap.get((Object)str.toUpperCase()));
        }

        static {
            strMap = ImmutableMap.of((Object)"GET", (Object)((Object)GET), (Object)"POST", (Object)((Object)POST), (Object)"HEAD", (Object)((Object)HEAD), (Object)"DELETE", (Object)((Object)DELETE), (Object)"PUT", (Object)((Object)PUT));
        }
    }
}

