/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.api.http;

import java.util.Properties;
import org.attribyte.api.InitializationException;
import org.attribyte.util.InitUtil;

public class ClientOptions {
    public static final ClientOptions IMPLEMENTATION_DEFAULT = new ClientOptions();
    public final String userAgent;
    public final int connectionTimeoutMillis;
    public final int requestTimeoutMillis;
    public final int socketTimeoutMillis;
    public final String proxyHost;
    public final int proxyPort;
    public final boolean followRedirects;
    public final int maxConnectionsPerDestination;
    public final int maxConnectionsTotal;
    public final int requestBufferSize;
    public final int responseBufferSize;
    private final Properties props;
    static final int KEY = 0;
    static final int DEFAULT_VALUE = 1;
    static final String[] USER_AGENT = new String[]{"userAgent", "AttribyteHttp/1.0"};
    static final String[] CONNECTION_TIMEOUT = new String[]{"connectionTimeout", "5s"};
    static final String[] REQUEST_TIMEOUT = new String[]{"requestTimeout", "5s"};
    static final String[] SOCKET_TIMEOUT = new String[]{"socketTimeout", "5s"};
    static final String[] PROXY_HOST = new String[]{"proxyHost", null};
    static final String[] PROXY_PORT = new String[]{"proxyPort", "0"};
    static final String[] FOLLOW_REDIRECTS = new String[]{"followRedirects", "true"};
    static final String[] MAX_CONNECTIONS_PER_DESTINATION = new String[]{"maxConnectionsPerDestination", "1024"};
    static final String[] MAX_CONNECTIONS_TOTAL = new String[]{"maxConnectionsPerDestination", "4096"};
    static final String[] REQUEST_BUFFER_SIZE = new String[]{"requestBufferSize", "4096"};
    static final String[] RESPONSE_BUFFER_SIZE = new String[]{"responseBufferSize", "16384"};

    public String getProperty(String name, String defaultValue) {
        String val = this.props.getProperty(name);
        return val != null ? val : defaultValue;
    }

    public int getIntProperty(String name, int defaultValue) {
        String val = this.props.getProperty(name);
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException ne) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String val = this.props.getProperty(name);
        if (val != null) {
            return val.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    public int getTimeProperty(String name, int defaultValue) {
        String val = this.props.getProperty(name);
        if (val != null) {
            try {
                return (int)InitUtil.millisFromTime((String)val);
            }
            catch (InitializationException ie) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public ClientOptions(String prefix, Properties props) throws InitializationException {
        InitUtil init = new InitUtil(prefix, props, false);
        this.userAgent = init.getProperty(USER_AGENT[0], USER_AGENT[1]);
        this.connectionTimeoutMillis = (int)InitUtil.millisFromTime((String)init.getProperty(CONNECTION_TIMEOUT[0], CONNECTION_TIMEOUT[1]));
        this.requestTimeoutMillis = (int)InitUtil.millisFromTime((String)init.getProperty(REQUEST_TIMEOUT[0], REQUEST_TIMEOUT[1]));
        this.socketTimeoutMillis = (int)InitUtil.millisFromTime((String)init.getProperty(SOCKET_TIMEOUT[0], SOCKET_TIMEOUT[1]));
        this.proxyHost = init.getProperty(PROXY_HOST[0], PROXY_HOST[1]);
        this.proxyPort = init.getIntProperty(PROXY_PORT[0], Integer.parseInt(PROXY_PORT[1]));
        this.followRedirects = init.getProperty(FOLLOW_REDIRECTS[0], FOLLOW_REDIRECTS[1]).equalsIgnoreCase("true");
        this.maxConnectionsPerDestination = init.getIntProperty(MAX_CONNECTIONS_PER_DESTINATION[0], Integer.parseInt(MAX_CONNECTIONS_PER_DESTINATION[1]));
        this.maxConnectionsTotal = init.getIntProperty(MAX_CONNECTIONS_TOTAL[0], Integer.parseInt(MAX_CONNECTIONS_TOTAL[1]));
        this.requestBufferSize = init.getIntProperty(REQUEST_BUFFER_SIZE[0], Integer.parseInt(REQUEST_BUFFER_SIZE[1]));
        this.responseBufferSize = init.getIntProperty(RESPONSE_BUFFER_SIZE[0], Integer.parseInt(RESPONSE_BUFFER_SIZE[1]));
        this.props = init.getProperties();
    }

    ClientOptions(String userAgent, int connectionTimeoutMillis, int requestTimeoutMillis, int socketTimeoutMillis, String proxyHost, int proxyPort, boolean followRedirects, int maxConnectionsPerDestination, int maxConnectionsTotal, int requestBufferSize, int responseBufferSize, Properties props) {
        this.userAgent = userAgent;
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        this.requestTimeoutMillis = requestTimeoutMillis;
        this.socketTimeoutMillis = socketTimeoutMillis;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.followRedirects = followRedirects;
        this.maxConnectionsPerDestination = maxConnectionsPerDestination;
        this.maxConnectionsTotal = maxConnectionsTotal;
        this.requestBufferSize = requestBufferSize;
        this.responseBufferSize = responseBufferSize;
        this.props = props;
    }

    private ClientOptions() {
        this.userAgent = null;
        this.connectionTimeoutMillis = 0;
        this.requestTimeoutMillis = 0;
        this.socketTimeoutMillis = 0;
        this.proxyHost = null;
        this.proxyPort = 0;
        this.followRedirects = false;
        this.maxConnectionsPerDestination = 0;
        this.maxConnectionsTotal = 0;
        this.requestBufferSize = 0;
        this.responseBufferSize = 0;
        this.props = null;
    }

    public static class Builder {
        String userAgent = USER_AGENT[1];
        int connectionTimeoutMillis = this.fromTime(CONNECTION_TIMEOUT[1]);
        int requestTimeoutMillis = this.fromTime(REQUEST_TIMEOUT[1]);
        int socketTimeoutMillis = this.fromTime(SOCKET_TIMEOUT[1]);
        String proxyHost = PROXY_HOST[1];
        int proxyPort = Integer.parseInt(PROXY_PORT[1]);
        boolean followRedirects = FOLLOW_REDIRECTS[1].equalsIgnoreCase("true");
        int maxConnectionsPerDestination = Integer.parseInt(MAX_CONNECTIONS_PER_DESTINATION[1]);
        int maxConnectionsTotal = Integer.parseInt(MAX_CONNECTIONS_TOTAL[1]);
        int requestBufferSize = Integer.parseInt(REQUEST_BUFFER_SIZE[1]);
        int responseBufferSize = Integer.parseInt(RESPONSE_BUFFER_SIZE[1]);
        Properties props = new Properties();

        public String getUserAgent() {
            return this.userAgent;
        }

        public void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        public int getConnectionTimeoutMillis() {
            return this.connectionTimeoutMillis;
        }

        public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
            this.connectionTimeoutMillis = connectionTimeoutMillis;
        }

        public int getRequestTimeoutMillis() {
            return this.requestTimeoutMillis;
        }

        public void setRequestTimeoutMillis(int requestTimeoutMillis) {
            this.requestTimeoutMillis = requestTimeoutMillis;
        }

        public int getSocketTimeoutMillis() {
            return this.socketTimeoutMillis;
        }

        public void setSocketTimeoutMillis(int socketTimeoutMillis) {
            this.socketTimeoutMillis = socketTimeoutMillis;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public void setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
        }

        public int getProxyPort() {
            return this.proxyPort;
        }

        public void setProxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
        }

        public boolean getFollowRedirects() {
            return this.followRedirects;
        }

        public void setFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
        }

        public int getMaxConnectionsPerDestination() {
            return this.maxConnectionsPerDestination;
        }

        public void setMaxConnectionsPerDestination(int maxConnectionsPerDestination) {
            this.maxConnectionsPerDestination = maxConnectionsPerDestination;
        }

        public int getMaxConnectionsTotal() {
            return this.maxConnectionsTotal;
        }

        public void setMaxConnectionsTotal(int maxConnectionsTotal) {
            this.maxConnectionsTotal = maxConnectionsTotal;
        }

        public int getRequestBufferSize() {
            return this.requestBufferSize;
        }

        public void setRequestBufferSize(int requestBufferSize) {
            this.requestBufferSize = requestBufferSize;
        }

        public int getResponseBufferSize() {
            return this.responseBufferSize;
        }

        public void setResponseBufferSize(int responseBufferSize) {
            this.responseBufferSize = responseBufferSize;
        }

        public Properties getProps() {
            return this.props;
        }

        public void setProps(Properties props) {
            this.props = props != null ? props : new Properties();
        }

        public ClientOptions create() {
            return new ClientOptions(this.userAgent, this.connectionTimeoutMillis, this.requestTimeoutMillis, this.socketTimeoutMillis, this.proxyHost, this.proxyPort, this.followRedirects, this.maxConnectionsPerDestination, this.maxConnectionsTotal, this.requestBufferSize, this.responseBufferSize, this.props);
        }

        private int fromTime(String timeString) {
            try {
                return (int)InitUtil.millisFromTime((String)timeString);
            }
            catch (InitializationException ie) {
                return 0;
            }
        }
    }
}

