/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.api.http.util;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.attribyte.api.Logger;
import org.attribyte.api.http.Client;
import org.attribyte.api.http.GetRequestBuilder;
import org.attribyte.api.http.Request;
import org.attribyte.api.http.Response;

public class RobotsTxt {
    private final Map<String, List<String>[]> agentMap = Maps.newHashMapWithExpectedSize((int)8);
    private static final int DISALLOW = 1;
    private static final int ALLOW = 0;
    private static final String EMPTY_PATH = "";
    public static final RobotsTxt NO_ROBOTS = new RobotsTxt();

    public static RobotsTxt parse(String host, Client httpClient, String userAgent, Set<String> preserveAgents, Logger logger) {
        String url = host + "/robots.txt";
        if (!url.startsWith("http://")) {
            url = "http://" + url;
        }
        try {
            Request request = new GetRequestBuilder(url).addHeader("User-Agent", userAgent).create();
            Response response = httpClient.send(request);
            int responseCode = response.getStatusCode();
            if (responseCode == 200) {
                ByteString body = response.getBody();
                if (body == null) {
                    return NO_ROBOTS;
                }
                byte[] bodyBytes = body.toByteArray();
                if (bodyBytes.length > 0) {
                    return new RobotsTxt(new InputStreamReader((InputStream)new ByteArrayInputStream(bodyBytes), Charsets.UTF_8), preserveAgents);
                }
                return NO_ROBOTS;
            }
            return NO_ROBOTS;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            if (logger != null) {
                logger.warn("I/O error during parse of " + url, (Throwable)ioe);
            }
            return NO_ROBOTS;
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (logger != null) {
                logger.warn("Error during parse of " + url, t);
            }
            return NO_ROBOTS;
        }
    }

    private RobotsTxt() {
    }

    public RobotsTxt(Reader r, Set<String> agents) throws IOException {
        HashSet preserveAgents = null;
        if (agents != null) {
            preserveAgents = Sets.newHashSetWithExpectedSize((int)(agents.size() + 1));
            preserveAgents.add("*");
            for (String agent : agents) {
                preserveAgents.add(agent.toLowerCase().trim());
            }
        }
        ArrayList[] currRecordLists = null;
        boolean newAgent = false;
        List lines = CharStreams.readLines((Readable)r);
        for (String currLine : lines) {
            String path;
            if ((currLine = currLine.trim()).length() == 0 || currLine.startsWith("#")) continue;
            if ((currLine = currLine.toLowerCase()).startsWith("user-agent")) {
                String currAgent = this.getValue(currLine);
                if (currAgent == null) continue;
                if (currRecordLists == null || newAgent) {
                    currRecordLists = new ArrayList[2];
                    newAgent = false;
                }
                if (preserveAgents == null) {
                    this.agentMap.put(currAgent, currRecordLists);
                    continue;
                }
                if (!preserveAgents.contains(currAgent)) continue;
                this.agentMap.put(currAgent, currRecordLists);
                continue;
            }
            if (currLine.startsWith("disallow")) {
                newAgent = true;
                path = this.getValue(currLine);
                if (path == null || path.length() == 0) {
                    path = EMPTY_PATH;
                }
                if (currRecordLists == null) continue;
                if (currRecordLists[1] == null) {
                    currRecordLists[1] = new ArrayList(8);
                }
                currRecordLists[1].add(path);
                continue;
            }
            if (currLine.startsWith("allow")) {
                newAgent = true;
                path = this.getValue(currLine);
                if (path == null || path.length() == 0) {
                    path = EMPTY_PATH;
                }
                if (currRecordLists == null) continue;
                if (currRecordLists[0] == null) {
                    currRecordLists[0] = new ArrayList(8);
                }
                currRecordLists[0].add(path);
                continue;
            }
            newAgent = true;
        }
    }

    public final boolean isAllowed(String userAgent, String path) {
        return this.isAllowed(userAgent, path, true);
    }

    public final boolean isAllowed(String userAgent, String path, boolean checkWildcard) {
        List<String> disallowList;
        List<String>[] agentLists;
        String string = path = path == null ? "/" : path.toLowerCase().trim();
        if (path.length() == 0) {
            path = "/";
        }
        if ((agentLists = this.agentMap.get(userAgent = userAgent.toLowerCase().trim())) == null && checkWildcard) {
            agentLists = this.agentMap.get("*");
        }
        if (agentLists == null) {
            return true;
        }
        List<String> allowList = agentLists[0];
        if (allowList != null) {
            for (String matchPath : allowList) {
                if (matchPath == EMPTY_PATH) {
                    return false;
                }
                if (!path.startsWith(matchPath)) continue;
                return true;
            }
        }
        if ((disallowList = agentLists[1]) == null && allowList != null) {
            return false;
        }
        if (disallowList == null) {
            return true;
        }
        for (String matchPath : disallowList) {
            if (matchPath == EMPTY_PATH) {
                return true;
            }
            if (!path.startsWith(matchPath)) continue;
            return false;
        }
        return true;
    }

    private String getValue(String currLine) {
        int index = currLine.indexOf(":");
        if (index == -1) {
            return null;
        }
        if (index == currLine.length() - 1) {
            return null;
        }
        int endIndex = currLine.indexOf("#");
        if (endIndex > 0) {
            return currLine.substring(index + 1, endIndex).trim();
        }
        return currLine.substring(index + 1).trim();
    }
}

