/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.api.http.impl.ning;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.RequestBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.attribyte.api.InitializationException;
import org.attribyte.api.Logger;
import org.attribyte.api.http.AsyncClient;
import org.attribyte.api.http.ClientOptions;
import org.attribyte.api.http.Header;
import org.attribyte.api.http.Parameter;
import org.attribyte.api.http.Request;
import org.attribyte.api.http.RequestOptions;
import org.attribyte.api.http.Response;
import org.attribyte.api.http.ResponseBuilder;

public class NingClient
implements AsyncClient {
    private AsyncHttpClient httpClient;
    private final AtomicBoolean isInit = new AtomicBoolean(false);

    private void initFromOptions(ClientOptions options) {
        if (options != ClientOptions.IMPLEMENTATION_DEFAULT) {
            AsyncHttpClientConfig.Builder config = new AsyncHttpClientConfig.Builder();
            config.setUserAgent(options.userAgent);
            if (options.proxyHost != null) {
                config.setProxyServer(new ProxyServer(options.proxyHost, options.proxyPort));
            }
            config.setConnectionTimeoutInMs(options.connectionTimeoutMillis);
            config.setRequestTimeoutInMs(options.requestTimeoutMillis);
            config.setFollowRedirects(options.followRedirects);
            config.setMaximumConnectionsPerHost(options.maxConnectionsPerDestination);
            config.setMaximumConnectionsTotal(options.maxConnectionsTotal);
            config.setFollowRedirects(true);
            config.setAllowPoolingConnection(options.getBooleanProperty("allowPoolingConnection", true));
            config.setIOThreadMultiplier(options.getIntProperty("ioThreadMultiplier", 2));
            config.setIdleConnectionInPoolTimeoutInMs(options.getTimeProperty("idleConnectionInPoolTimeout", 60000));
            config.setIdleConnectionTimeoutInMs(options.getTimeProperty("idleConnectionTimeout", 60000));
            config.setMaxConnectionLifeTimeInMs(options.getTimeProperty("maxConnectionLife", -1));
            config.setCompressionEnabled(options.getBooleanProperty("compressionEnabled", false));
            config.setRequestCompressionLevel(options.getIntProperty("requestCompressionLevel", 1));
            this.httpClient = new AsyncHttpClient(config.build());
        } else {
            this.httpClient = new AsyncHttpClient(new AsyncHttpClientConfig.Builder().build());
        }
    }

    public NingClient() {
    }

    public NingClient(ClientOptions options) {
        this.initFromOptions(options);
    }

    public NingClient(AsyncHttpClient asyncHttpClient) {
        this.httpClient = asyncHttpClient;
    }

    @Override
    public void init(String prefix, Properties props, Logger logger) throws InitializationException {
        if (this.isInit.compareAndSet(false, true)) {
            this.initFromOptions(new ClientOptions(prefix, props));
        }
    }

    @Override
    public Response send(Request request) throws IOException {
        return this.send(request, RequestOptions.DEFAULT);
    }

    @Override
    public Response send(Request request, RequestOptions options) throws IOException {
        try {
            return (Response)this.asyncSend(request, options).get((long)options.timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (TimeoutException te) {
            throw new IOException(te);
        }
        catch (ExecutionException ee) {
            throw new IOException(ee);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    @Override
    public ListenableFuture<Response> asyncSend(Request request) {
        return this.asyncSend(request, RequestOptions.DEFAULT);
    }

    @Override
    public ListenableFuture<Response> asyncSend(Request request, final RequestOptions options) {
        final SettableFuture fut = SettableFuture.create();
        try {
            this.httpClient.executeRequest(this.toNingRequest(request, options), (AsyncHandler)new AsyncCompletionHandler<com.ning.http.client.Response>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public com.ning.http.client.Response onCompleted(com.ning.http.client.Response response) throws Exception {
                    ResponseBuilder builder = new ResponseBuilder();
                    builder.setStatusCode(response.getStatusCode());
                    Set entries = response.getHeaders().entrySet();
                    for (Map.Entry header : entries) {
                        builder.addHeader((String)header.getKey(), (String)((List)header.getValue()).get(0));
                    }
                    InputStream is = response.getResponseBodyAsStream();
                    if (is != null) {
                        try {
                            builder.setBody(Request.bodyFromInputStream(is, options.maxResponseBytes));
                        }
                        finally {
                            try {
                                is.close();
                            }
                            catch (IOException ioe) {}
                        }
                    }
                    fut.set((Object)builder.create());
                    return response;
                }

                public void onThrowable(Throwable t) {
                    fut.setException(t);
                }
            });
        }
        catch (Throwable t) {
            fut.setException(t);
        }
        return fut;
    }

    @Override
    public void shutdown() throws Exception {
        this.httpClient.close();
    }

    private com.ning.http.client.Request toNingRequest(Request request, RequestOptions options) {
        RequestBuilder ningRequestBuilder = new RequestBuilder();
        ningRequestBuilder.setURI(request.getURI());
        ningRequestBuilder.setFollowRedirects(options.followRedirects);
        switch (request.getMethod()) {
            case GET: {
                ningRequestBuilder.setMethod("GET");
                break;
            }
            case POST: {
                ningRequestBuilder.setMethod("POST");
                Collection<Parameter> parameters = request.getParameters();
                if (parameters.size() > 0) {
                    for (Parameter parameter : parameters) {
                        ningRequestBuilder.addParameter(parameter.getName(), parameter.getValue());
                    }
                    break;
                }
                if (request.getBody() == null) break;
                ningRequestBuilder.setBody(request.getBody().toByteArray());
                break;
            }
            case PUT: {
                ningRequestBuilder.setMethod("PUT");
                if (request.getBody() == null) break;
                ningRequestBuilder.setBody(request.getBody().toByteArray());
                break;
            }
            case DELETE: {
                ningRequestBuilder.setMethod("DELETE");
                break;
            }
            case HEAD: {
                ningRequestBuilder.setMethod("HEAD");
            }
        }
        Collection<Header> headers = request.getHeaders();
        for (Header header : headers) {
            ningRequestBuilder.addHeader(header.getName(), header.getValue());
        }
        return ningRequestBuilder.build();
    }
}

