/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.api.http;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.google.protobuf.ByteString;
import java.util.Collection;
import java.util.Map;
import org.attribyte.api.http.BodyResponse;
import org.attribyte.api.http.Header;
import org.attribyte.api.http.Response;
import org.attribyte.api.http.StreamedResponse;

public class ResponseBuilder {
    final Map<String, Header> headers = Maps.newHashMapWithExpectedSize((int)8);
    Map<String, Object> attributes = null;
    ByteString body = null;
    ByteSource bodySource = null;
    int statusCode;

    public ResponseBuilder() {
    }

    public ResponseBuilder(int statusCode) {
        this.statusCode = statusCode;
    }

    public ResponseBuilder(int statusCode, byte[] body) {
        this.statusCode = statusCode;
        this.body = body != null ? ByteString.copyFrom((byte[])body) : null;
    }

    public ResponseBuilder(int statusCode, String body) {
        this.statusCode = statusCode;
        this.body = body != null ? ByteString.copyFrom((byte[])body.getBytes(Charsets.UTF_8)) : null;
    }

    public ResponseBuilder(int statusCode, ByteSource bodySource) {
        this.statusCode = statusCode;
        this.bodySource = bodySource;
    }

    public ResponseBuilder setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public ResponseBuilder setBody(byte[] body) {
        this.body = body != null ? ByteString.copyFrom((byte[])body) : null;
        return this;
    }

    public ResponseBuilder setBody(String body) {
        this.body = body != null ? ByteString.copyFrom((byte[])body.getBytes(Charsets.UTF_8)) : null;
        return this;
    }

    public ResponseBuilder setBody(ByteSource body) {
        this.bodySource = body;
        return this;
    }

    public Response create() {
        return this.bodySource == null ? new BodyResponse(this.statusCode, this.headers, this.body, this.attributes) : new StreamedResponse(this.statusCode, this.headers, this.bodySource, this.attributes);
    }

    public StreamedResponse createStreamed() {
        ByteSource bodySource = this.bodySource != null ? this.bodySource : (this.body != null ? ByteSource.wrap((byte[])this.body.toByteArray()) : null);
        return new StreamedResponse(this.statusCode, this.headers, bodySource, this.attributes);
    }

    public ResponseBuilder addHeader(String name, String value) {
        String lcName = name.toLowerCase();
        Header currHeader = this.headers.get(lcName);
        if (currHeader == null) {
            this.headers.put(lcName, new Header(name, value));
        } else {
            this.headers.put(lcName, currHeader.addValue(value));
        }
        return this;
    }

    public ResponseBuilder putHeaders(Collection<Header> headers) {
        if (headers != null) {
            for (Header header : headers) {
                this.headers.put(header.getName().toLowerCase(), header);
            }
        }
        return this;
    }

    public ResponseBuilder addHeaders(Map<?, ?> headerMap) {
        if (headerMap != null) {
            this.headers.putAll(Header.createMap(headerMap));
        }
        return this;
    }

    public ResponseBuilder addAttribute(String name, Object object) {
        this.maybeCreateAttributes().put(name, object);
        return this;
    }

    public ResponseBuilder addAttributes(Map<String, Object> attributes) {
        if (attributes != null) {
            this.maybeCreateAttributes().putAll(attributes);
        }
        return this;
    }

    private Map<String, Object> maybeCreateAttributes() {
        if (this.attributes == null) {
            this.attributes = Maps.newHashMapWithExpectedSize((int)4);
        }
        return this.attributes;
    }
}

