/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.api.http;

import com.google.common.collect.Maps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import org.attribyte.api.InvalidURIException;
import org.attribyte.api.http.Header;
import org.attribyte.api.http.Request;

public abstract class RequestBuilder {
    final Map<String, Header> headers = Maps.newHashMapWithExpectedSize((int)8);
    final Map<String, Object> attributes = Maps.newHashMapWithExpectedSize((int)2);
    final URI uri;

    protected RequestBuilder(String uri) throws InvalidURIException {
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException use) {
            throw new InvalidURIException(use);
        }
    }

    protected RequestBuilder(URI uri) {
        this.uri = uri;
    }

    public abstract Request create();

    public RequestBuilder addHeader(String name, String value) {
        String lcName = name.toLowerCase();
        Header currHeader = this.headers.get(lcName);
        if (currHeader == null) {
            this.headers.put(lcName, new Header(name, value));
        } else {
            this.headers.put(lcName, currHeader.addValue(value));
        }
        return this;
    }

    public RequestBuilder addHeaders(Collection<Header> headers) {
        if (headers != null) {
            for (Header header : headers) {
                this.headers.put(header.getName().toLowerCase(), header);
            }
        }
        return this;
    }

    public RequestBuilder addHeaders(Map<?, ?> headerMap) {
        if (headerMap != null) {
            this.headers.putAll(Header.createMap(headerMap));
        }
        return this;
    }

    public RequestBuilder addAttribute(String name, Object object) {
        this.attributes.put(name, object);
        return this;
    }

    public RequestBuilder addAttributes(Map<String, Object> attributes) {
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
        return this;
    }
}

