/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.api.http;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.attribyte.api.http.NamedValues;
import org.attribyte.api.http.Parameter;

public final class Header {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final Comparator<Header> nameComparator = new Comparator<Header>(){

        @Override
        public int compare(Header h1, Header h2) {
            return h1.name.compareToIgnoreCase(h2.name);
        }
    };
    private static Splitter.MapSplitter parameterSplitter = Splitter.on((char)';').omitEmptyStrings().limit(16).trimResults().withKeyValueSeparator('=');
    public final String name;
    public final ImmutableList<String> values;

    public Header(String name, String value) {
        this.name = name;
        this.values = Strings.isNullOrEmpty((String)value) ? ImmutableList.of() : ImmutableList.of((Object)value);
    }

    public Header(String name, String[] values) {
        this.name = name;
        this.values = NamedValues.copyValues(values);
    }

    public Header(String name, Collection<String> values) {
        this.name = name;
        this.values = NamedValues.copyValues(values);
    }

    public Header addValue(String value) {
        return new Header(this.name, (Collection<String>)ImmutableList.builder().addAll(this.values).add((Object)value).build());
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.values.isEmpty() ? "" : (String)this.values.get(0);
    }

    public String[] getValues() {
        return (String[])this.values.toArray((Object[])new String[this.values.size()]);
    }

    public ImmutableList<String> getValueList() {
        return this.values;
    }

    public static List<Parameter> parseParameters(String headerValue) {
        if (headerValue == null) {
            return Collections.emptyList();
        }
        int start = headerValue.indexOf(59);
        if (start < 2) {
            return Collections.emptyList();
        }
        ArrayList parameters = Lists.newArrayListWithExpectedSize((int)4);
        try {
            Map parameterMap = parameterSplitter.split((CharSequence)headerValue.substring(start));
            for (Map.Entry kv : parameterMap.entrySet()) {
                parameters.add(new Parameter((String)kv.getKey(), (String)kv.getValue()));
            }
            return parameters;
        }
        catch (IllegalArgumentException iae) {
            return Collections.emptyList();
        }
    }

    public static String getCharset(String contentType, String defaultCharset) {
        if (contentType == null) {
            return defaultCharset;
        }
        List<Parameter> parameters = Header.parseParameters(contentType);
        for (Parameter parameter : parameters) {
            if (!parameter.name.equalsIgnoreCase("charset")) continue;
            return parameter.getValue();
        }
        return defaultCharset;
    }

    static final Map<String, Header> createMap(Map inputHeaders) {
        return Header.createMap(inputHeaders, Maps.newHashMapWithExpectedSize((int)inputHeaders.size()));
    }

    static final ImmutableMap<String, Header> createImmutableMap(Map inputHeaders) {
        if (inputHeaders == null) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf(Header.createMap(inputHeaders, Maps.newHashMapWithExpectedSize((int)inputHeaders.size())));
    }

    static final Map<String, Header> createMap(Map inputHeaders, Map<String, Header> outputMap) {
        if (inputHeaders == null) {
            return Maps.newHashMap();
        }
        for (Map.Entry entry : inputHeaders.entrySet()) {
            Object key = entry.getKey();
            String keyStr = key.toString().intern();
            String lcKey = keyStr.intern();
            Object value = entry.getValue();
            if (value instanceof Header) {
                outputMap.put(lcKey, (Header)value);
                continue;
            }
            if (value instanceof Collection) {
                Collection c = (Collection)value;
                ArrayList values = Lists.newArrayListWithExpectedSize((int)c.size());
                for (Object o : c) {
                    if (o == null) continue;
                    values.add(o.toString());
                }
                outputMap.put(lcKey, new Header(keyStr, values));
                continue;
            }
            if (value instanceof String[]) {
                outputMap.put(lcKey, new Header(keyStr, (String[])value));
                continue;
            }
            outputMap.put(lcKey, new Header(keyStr, value != null ? value.toString() : null));
        }
        return outputMap;
    }

    public String toString() {
        return NamedValues.toString(this.name, this.values);
    }
}

