/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.api.http;

import java.net.URI;
import java.util.Map;
import org.attribyte.api.InvalidURIException;
import org.attribyte.api.http.Header;
import org.attribyte.api.http.Parameter;
import org.attribyte.api.http.Request;
import org.attribyte.api.http.RequestBuilderWithParameters;

public class HeadRequestBuilder
extends RequestBuilderWithParameters {
    public HeadRequestBuilder(String uri, Map parameters) throws InvalidURIException {
        super(uri, parameters);
    }

    public HeadRequestBuilder(String uri, boolean caseSensitiveParameters) throws InvalidURIException {
        super(uri, caseSensitiveParameters);
        String qs = this.uri.getQuery();
        if (qs != null) {
            this.parameters.putAll(Request.parseParameters(qs, caseSensitiveParameters));
        }
    }

    public HeadRequestBuilder(URI uri, boolean caseSensitiveParameters) {
        super(uri, caseSensitiveParameters);
        String qs = this.uri.getQuery();
        if (qs != null) {
            this.parameters.putAll(Request.parseParameters(qs, caseSensitiveParameters));
        }
    }

    public HeadRequestBuilder(String uri) throws InvalidURIException {
        super(uri, true);
        String qs = this.uri.getQuery();
        if (qs != null) {
            this.parameters.putAll(Request.parseParameters(qs, this.caseSensitiveParameters));
        }
    }

    public HeadRequestBuilder(URI uri) {
        super(uri, true);
        String qs = this.uri.getQuery();
        if (qs != null) {
            this.parameters.putAll(Request.parseParameters(qs, this.caseSensitiveParameters));
        }
    }

    @Override
    public Request create() {
        return new Request(Request.Method.HEAD, this.uri, (Map<String, Header>)this.headers, (Map<String, Parameter>)this.parameters, this.caseSensitiveParameters, (byte[])null, (Map<String, Object>)this.attributes);
    }
}

