/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.api.http.impl.jetty;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.net.CookieStore;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.attribyte.api.InitializationException;
import org.attribyte.api.Logger;
import org.attribyte.api.http.AsyncClient;
import org.attribyte.api.http.ClientOptions;
import org.attribyte.api.http.Header;
import org.attribyte.api.http.Parameter;
import org.attribyte.api.http.Request;
import org.attribyte.api.http.RequestOptions;
import org.attribyte.api.http.Response;
import org.attribyte.api.http.ResponseBuilder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.client.util.ByteBufferContentProvider;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettyClient
implements AsyncClient {
    private HttpClient httpClient;
    private final AtomicBoolean isInit = new AtomicBoolean(false);

    public JettyClient() {
    }

    public JettyClient(ClientOptions options) throws InitializationException {
        this.initFromOptions(options);
    }

    private void initFromOptions(ClientOptions options) throws InitializationException {
        SslContextFactory sslContextFactory;
        if (options != ClientOptions.IMPLEMENTATION_DEFAULT) {
            sslContextFactory = new SslContextFactory();
            this.httpClient = new HttpClient(sslContextFactory);
            this.httpClient.setFollowRedirects(options.followRedirects);
            this.httpClient.setConnectTimeout((long)options.connectionTimeoutMillis);
            this.httpClient.setMaxConnectionsPerDestination(options.maxConnectionsPerDestination);
            this.httpClient.setCookieStore((CookieStore)new HttpCookieStore.Empty());
            if (options.proxyHost != null) {
                ProxyConfiguration proxyConfig = this.httpClient.getProxyConfiguration();
                proxyConfig.getProxies().add(new HttpProxy(options.proxyHost, options.proxyPort));
            }
            this.httpClient.setUserAgentField(new HttpField(HttpHeader.USER_AGENT, options.userAgent));
            this.httpClient.setRequestBufferSize(options.requestBufferSize);
            this.httpClient.setResponseBufferSize(options.responseBufferSize);
            this.httpClient.setIdleTimeout((long)options.getIntProperty("idleTimeout", 0));
            this.httpClient.setAddressResolutionTimeout((long)options.getIntProperty("addressResolutionTimeout", 15000));
            this.httpClient.setMaxRedirects(options.getIntProperty("maxRedirects", 8));
            this.httpClient.setMaxRequestsQueuedPerDestination(options.getIntProperty("maxRequestsQueuedPerDestination", 1024));
            this.httpClient.setDispatchIO(options.getBooleanProperty("dispatchIO", true));
        } else {
            sslContextFactory = new SslContextFactory();
            this.httpClient = new HttpClient(sslContextFactory);
        }
        try {
            this.httpClient.start();
        }
        catch (Exception e) {
            throw new InitializationException("Problem starting client", (Throwable)e);
        }
    }

    @Override
    public synchronized void init(String prefix, Properties props, Logger logger) throws InitializationException {
        if (this.isInit.compareAndSet(false, true)) {
            this.initFromOptions(new ClientOptions(prefix, props));
        }
    }

    @Override
    public Response send(Request request) throws IOException {
        return this.send(request, RequestOptions.DEFAULT);
    }

    @Override
    public Response send(Request request, RequestOptions options) throws IOException {
        try {
            return (Response)this.asyncSend(request, options).get((long)options.timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (TimeoutException te) {
            throw new IOException(te);
        }
        catch (ExecutionException ee) {
            throw new IOException(ee);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    @Override
    public ListenableFuture<Response> asyncSend(Request request) {
        return this.asyncSend(request, RequestOptions.DEFAULT);
    }

    @Override
    public ListenableFuture<Response> asyncSend(Request request, RequestOptions options) {
        final SettableFuture fut = SettableFuture.create();
        this.toJettyRequest(request).followRedirects(options.followRedirects).send((Response.CompleteListener)new BufferingResponseListener(options.maxResponseBytes){

            public void onComplete(Result result) {
                if (!result.isFailed()) {
                    ResponseBuilder builder = new ResponseBuilder();
                    org.eclipse.jetty.client.api.Response response = result.getResponse();
                    builder.setStatusCode(response.getStatus());
                    HttpFields headers = response.getHeaders();
                    for (HttpField header : headers) {
                        builder.addHeader(header.getName(), header.getValue());
                    }
                    byte[] responseContent = this.getContent();
                    if (responseContent != null) {
                        builder.setBody(responseContent);
                    }
                    fut.set((Object)builder.create());
                } else {
                    fut.setException(result.getFailure());
                }
            }
        });
        return fut;
    }

    @Override
    public void shutdown() throws Exception {
        this.httpClient.stop();
    }

    private org.eclipse.jetty.client.api.Request toJettyRequest(Request request) {
        org.eclipse.jetty.client.api.Request jettyRequest = this.httpClient.newRequest(request.getURI());
        switch (request.getMethod()) {
            case GET: {
                jettyRequest.method(HttpMethod.GET);
                break;
            }
            case POST: {
                jettyRequest.method(HttpMethod.POST);
                Collection<Parameter> parameters = request.getParameters();
                if (parameters.size() > 0) {
                    for (Parameter parameter : parameters) {
                        jettyRequest.param(parameter.getName(), parameter.getValue());
                    }
                    break;
                }
                if (request.getBody() == null) break;
                jettyRequest.content((ContentProvider)new ByteBufferContentProvider(new ByteBuffer[]{request.getBody().asReadOnlyByteBuffer()}));
                break;
            }
            case PUT: {
                jettyRequest.method(HttpMethod.PUT);
                if (request.getBody() == null) break;
                jettyRequest.content((ContentProvider)new ByteBufferContentProvider(new ByteBuffer[]{request.getBody().asReadOnlyByteBuffer()}));
                break;
            }
            case DELETE: {
                jettyRequest.method(HttpMethod.DELETE);
                break;
            }
            case HEAD: {
                jettyRequest.method(HttpMethod.HEAD);
            }
        }
        Collection<Header> headers = request.getHeaders();
        for (Header header : headers) {
            jettyRequest.header(header.getName(), header.getValue());
        }
        return jettyRequest;
    }
}

