/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.api.http.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.attribyte.api.http.AuthScheme;
import org.attribyte.api.http.Header;
import org.attribyte.api.http.Request;
import org.attribyte.api.http.Response;

public class BasicAuthScheme
extends AuthScheme {
    private final Response INVALID_FORMAT_RESPONSE = this.getUnauthorizedResponse("Invalid format");
    private final Response INVALID_SCHEME_RESPONSE = this.getUnauthorizedResponse("Invalid scheme");
    private final Response UNAUTHORIZED_RESPONSE = this.getUnauthorizedResponse(null);
    public static final String AUTH_HEADER = "Authorization";
    private static final HashFunction HASH_FUNCTION = Hashing.sha1();

    public BasicAuthScheme() {
        super("Basic", "");
    }

    public BasicAuthScheme(String realm) {
        super("Basic", realm == null ? "" : realm);
    }

    @Override
    public Request addAuth(Request request, String id, String secret) throws GeneralSecurityException {
        return request.addHeaders(BasicAuthScheme.buildAuthHeaders(request, id, secret));
    }

    @Override
    public boolean hasCredentials(Request request) {
        String auth = request.getHeaderValue(AUTH_HEADER);
        return auth != null && auth.toLowerCase().startsWith("basic ");
    }

    @Override
    public String getUserId(Request request) throws GeneralSecurityException {
        String authorization = request.getHeaderValue(AUTH_HEADER);
        if (Strings.isNullOrEmpty((String)authorization)) {
            return null;
        }
        if (!authorization.toLowerCase().startsWith("basic ")) {
            return null;
        }
        String upass = new String(Base64.decodeBase64((String)(authorization = authorization.substring(6).trim())), Charsets.US_ASCII).trim();
        int index = upass.indexOf(58);
        if (index < 1) {
            return null;
        }
        return upass.substring(0, index);
    }

    @Override
    public Response authenticate(Request request, String userId, String secret) throws GeneralSecurityException {
        HashCode hash1;
        String authorization = request.getHeaderValue(AUTH_HEADER);
        if (Strings.isNullOrEmpty((String)authorization)) {
            return this.UNAUTHORIZED_RESPONSE;
        }
        if (!authorization.toLowerCase().startsWith("basic ")) {
            return this.INVALID_SCHEME_RESPONSE;
        }
        String upass = new String(Base64.decodeBase64((String)(authorization = authorization.substring(6).trim())), Charsets.US_ASCII).trim();
        int index = upass.indexOf(58);
        if (index < 1) {
            return this.INVALID_FORMAT_RESPONSE;
        }
        HashCode hash0 = HASH_FUNCTION.hashString((CharSequence)upass, Charsets.UTF_8);
        return hash0.equals((Object)(hash1 = HASH_FUNCTION.newHasher().putString((CharSequence)userId, Charsets.UTF_8).putString((CharSequence)":", Charsets.UTF_8).putString((CharSequence)secret, Charsets.UTF_8).hash())) ? null : this.UNAUTHORIZED_RESPONSE;
    }

    public static final String buildAuthHeaderValue(String username, String password) {
        StringBuilder buf = new StringBuilder(username.trim());
        buf.append(":");
        buf.append(password.trim());
        String up = buf.toString();
        buf.setLength(0);
        byte[] bytes = Base64.encodeBase64((byte[])up.getBytes());
        buf.append("Basic ");
        buf.append(new String(bytes, Charsets.UTF_8));
        return buf.toString();
    }

    private static List<Header> buildAuthHeaders(Request request, String username, String password) {
        Header header = new Header(AUTH_HEADER, BasicAuthScheme.buildAuthHeaderValue(username, password));
        return Collections.singletonList(header);
    }
}

