/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.api.http;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.attribyte.api.http.NamedValues;

public final class Parameter {
    public static final Comparator<Parameter> nameComparator = new Comparator<Parameter>(){

        @Override
        public int compare(Parameter p1, Parameter p2) {
            return p1.name.compareTo(p2.name);
        }
    };
    public final String name;
    public final ImmutableList<String> values;

    public Parameter(String name, String value) {
        this.name = name;
        this.values = Strings.isNullOrEmpty((String)value) ? ImmutableList.of() : ImmutableList.of((Object)value);
    }

    public Parameter(String name, String[] values) {
        this.name = name;
        this.values = NamedValues.copyValues(values);
    }

    public Parameter(String name, Collection<String> values) {
        this.name = name;
        this.values = NamedValues.copyValues(values);
    }

    public Parameter addValue(String value) {
        return new Parameter(this.name, (Collection<String>)ImmutableList.builder().addAll(this.values).add((Object)value).build());
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.values.isEmpty() ? "" : (String)this.values.get(0);
    }

    public String[] getValues() {
        return (String[])this.values.toArray((Object[])new String[this.values.size()]);
    }

    public ImmutableList<String> getValueList() {
        return this.values;
    }

    public String toString() {
        return NamedValues.toString(this.name, this.values);
    }

    static final Map<String, Parameter> createMap(Map inputParameters) {
        return Parameter.createMap(inputParameters, Maps.newHashMapWithExpectedSize((int)inputParameters.size()));
    }

    static final ImmutableMap<String, Parameter> createImmutableMap(Map inputParameters) {
        if (inputParameters == null) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf(Parameter.createMap(inputParameters));
    }

    static final Map<String, Parameter> createMap(Map inputParameters, Map<String, Parameter> outputMap) {
        if (inputParameters == null) {
            return Maps.newHashMap();
        }
        for (Map.Entry entry : inputParameters.entrySet()) {
            Object key = entry.getKey();
            String keyStr = key.toString();
            Object value = entry.getValue();
            if (value instanceof Parameter) {
                outputMap.put(keyStr, (Parameter)value);
                continue;
            }
            if (value instanceof Collection) {
                Collection c = (Collection)value;
                ArrayList values = Lists.newArrayListWithExpectedSize((int)c.size());
                for (Object o : c) {
                    if (o == null) continue;
                    values.add(o.toString());
                }
                outputMap.put(keyStr, new Parameter(keyStr, values));
                continue;
            }
            if (value instanceof String[]) {
                outputMap.put(keyStr, new Parameter(keyStr, (String[])value));
                continue;
            }
            outputMap.put(keyStr, new Parameter(keyStr, value != null ? value.toString() : null));
        }
        return outputMap;
    }
}

