/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.api.http;

import java.net.URI;
import java.util.Map;
import org.attribyte.api.InvalidURIException;
import org.attribyte.api.http.Header;
import org.attribyte.api.http.Parameter;
import org.attribyte.api.http.Request;
import org.attribyte.api.http.RequestBuilderWithParameters;

public class GetRequestBuilder
extends RequestBuilderWithParameters {
    public GetRequestBuilder(String uri, Map parameters) throws InvalidURIException {
        super(uri, parameters);
    }

    public GetRequestBuilder(String uri, boolean caseSensitiveParameters) throws InvalidURIException {
        super(uri, caseSensitiveParameters);
        String qs = this.uri.getQuery();
        if (qs != null) {
            this.parameters.putAll(Request.parseParameters(qs, caseSensitiveParameters));
        }
    }

    public GetRequestBuilder(URI uri, boolean caseSensitiveParameters) {
        super(uri, caseSensitiveParameters);
        String qs = this.uri.getQuery();
        if (qs != null) {
            this.parameters.putAll(Request.parseParameters(qs, caseSensitiveParameters));
        }
    }

    public GetRequestBuilder(String uri) throws InvalidURIException {
        super(uri, true);
        String qs = this.uri.getQuery();
        if (qs != null) {
            this.parameters.putAll(Request.parseParameters(qs, true));
        }
    }

    public GetRequestBuilder(URI uri) {
        super(uri, true);
        String qs = this.uri.getQuery();
        if (qs != null) {
            this.parameters.putAll(Request.parseParameters(qs, true));
        }
    }

    @Override
    public Request create() {
        return new Request(Request.Method.GET, this.uri, (Map<String, Header>)this.headers, (Map<String, Parameter>)this.parameters, this.caseSensitiveParameters, (byte[])null, (Map<String, Object>)this.attributes);
    }
}

