/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.api.http;

import com.google.common.base.Strings;
import java.security.GeneralSecurityException;
import org.attribyte.api.http.Request;
import org.attribyte.api.http.Response;
import org.attribyte.api.http.ResponseBuilder;

public abstract class AuthScheme {
    public static final String DEFAULT_UNAUTHORIZED_MESSAGE = "Authorization Required";
    public static final String AUTHENTICATE_RESPONSE_HEADER = "WWW-Authenticate";
    public final String scheme;
    public final String realm;
    public final String authenticateResponseHeader;

    protected AuthScheme(String scheme, String realm) {
        if (realm.contains("\"")) {
            throw new UnsupportedOperationException("The 'realm' must not contain the quote character");
        }
        this.scheme = scheme.intern();
        this.realm = Strings.nullToEmpty((String)realm);
        this.authenticateResponseHeader = this.scheme + " realm=\"" + this.realm + "\"";
    }

    public abstract boolean hasCredentials(Request var1);

    public abstract Request addAuth(Request var1, String var2, String var3) throws GeneralSecurityException;

    public abstract String getUserId(Request var1) throws GeneralSecurityException;

    public abstract Response authenticate(Request var1, String var2, String var3) throws GeneralSecurityException;

    public Response getUnauthorizedResponse(String message) {
        return new ResponseBuilder(401, message == null ? DEFAULT_UNAUTHORIZED_MESSAGE : message).addHeader(AUTHENTICATE_RESPONSE_HEADER, this.authenticateResponseHeader).create();
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getAuthenticateResponseHeader() {
        return this.authenticateResponseHeader;
    }

    public int hashCode() {
        return this.authenticateResponseHeader.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AuthScheme) {
            AuthScheme other = (AuthScheme)o;
            return this.authenticateResponseHeader.equals(other.authenticateResponseHeader);
        }
        return false;
    }
}

