/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.sql.pool;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.attribyte.sql.pool.Clock;
import org.attribyte.sql.pool.ConnectionPoolSegment;
import org.attribyte.sql.pool.Util;

public class ConnectionPoolConnection
implements Connection {
    static final int STATE_AVAILABLE = 0;
    static final int STATE_OPEN = 1;
    static final int STATE_CLOSING = 2;
    static final int STATE_REOPENING = 3;
    static final int STATE_DISCONNECTED = 4;
    private final ConnectionPoolSegment segment;
    final String id;
    private final String testSQL;
    private final IncompleteTransactionPolicy incompleteTransactionPolicy;
    private final OpenStatementPolicy openStatementPolicy;
    private final ForceRealClosePolicy forceRealClosePolicy;
    private final boolean debug;
    private volatile String lastTrace;
    private Connection conn;
    private final Set<Statement> openStatements;
    private static final Random rnd = new Random(System.currentTimeMillis());
    volatile long openTime;
    Throwable logicalCloseException;
    volatile long realOpenTime;
    volatile long lastTestTime;
    final AtomicInteger state = new AtomicInteger(0);
    private volatile TransactionState transactionState = TransactionState.CLOSED;
    int reopenAttempts;
    private final long closeTimeLimitMillis;
    private static final SimpleTimeLimiter closeTimeLimiter = new SimpleTimeLimiter();

    protected ConnectionPoolConnection(ConnectionPoolSegment segment, String id, String testSQL, boolean debug) {
        this(segment, id, testSQL, debug, IncompleteTransactionPolicy.REPORT, OpenStatementPolicy.SILENT, ForceRealClosePolicy.CONNECTION, 5000L);
    }

    protected ConnectionPoolConnection(ConnectionPoolSegment segment, String id, String testSQL, boolean debug, IncompleteTransactionPolicy incompleteTransactionPolicy, OpenStatementPolicy openStatementPolicy, ForceRealClosePolicy forceRealClosePolicy, long closeTimeLimitMillis) {
        this.segment = segment;
        this.id = id;
        this.testSQL = testSQL;
        this.incompleteTransactionPolicy = incompleteTransactionPolicy;
        this.openStatementPolicy = openStatementPolicy;
        this.forceRealClosePolicy = forceRealClosePolicy;
        this.openStatements = forceRealClosePolicy == ForceRealClosePolicy.STATEMENTS_AND_CONNECTION ? Collections.newSetFromMap(Maps.newConcurrentMap()) : Sets.newHashSet();
        this.debug = debug;
        this.closeTimeLimitMillis = closeTimeLimitMillis;
    }

    final String getStateAsString() {
        switch (this.state.get()) {
            case 0: {
                return "AVAILABLE";
            }
            case 1: {
                return "OPEN";
            }
            case 2: {
                return "CLOSING";
            }
            case 3: {
                return "REOPENING";
            }
            case 4: {
                return "DISCONNECTED";
            }
        }
        return "UNKNOWN";
    }

    /*
     * Loose catch block
     */
    @Override
    public void close() throws SQLException {
        switch (this.transactionState) {
            case CLOSED: {
                return;
            }
            case NONE: {
                this.transactionState = TransactionState.CLOSED;
                break;
            }
            default: {
                this.resolveIncompleteTransactions();
                this.transactionState = TransactionState.CLOSED;
                try {
                    if (this.conn.getAutoCommit()) break;
                    this.conn.setAutoCommit(true);
                }
                catch (Throwable t) {
                    this.setLogicalCloseException(t);
                }
                break;
                catch (Throwable t) {
                    try {
                        this.setLogicalCloseException(t);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (!this.conn.getAutoCommit()) {
                                this.conn.setAutoCommit(true);
                            }
                        }
                        catch (Throwable t2) {
                            this.setLogicalCloseException(t2);
                        }
                        throw throwable;
                    }
                    try {
                        if (this.conn.getAutoCommit()) break;
                        this.conn.setAutoCommit(true);
                    }
                    catch (Throwable t3) {
                        this.setLogicalCloseException(t3);
                    }
                    break;
                }
            }
        }
        boolean openStatements = this.closeStatements();
        Throwable logicalCloseException = this.logicalCloseException;
        this.segment.close(this);
        if (logicalCloseException != null) {
            Util.throwException(logicalCloseException);
        }
        if (openStatements && this.openStatementPolicy == OpenStatementPolicy.REPORT) {
            throw new SQLException("Connection has open statements", "08000");
        }
    }

    final void logicalOpen() {
        this.openTime = Clock.currTimeMillis;
        this.transactionState = TransactionState.NONE;
        if (this.debug) {
            this.lastTrace = Util.getFilteredStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void logicalOpenWithTest() throws SQLException {
        this.openTime = Clock.currTimeMillis;
        this.transactionState = TransactionState.NONE;
        if (this.debug) {
            this.lastTrace = Util.getFilteredStack();
        }
        if (this.testSQL != null && this.testSQL.length() > 0) {
            ResultSet rs = null;
            Statement stmt = null;
            try {
                stmt = this.conn.createStatement();
                rs = stmt.executeQuery(this.testSQL);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
        }
    }

    final void realOpen() throws SQLException {
        if (this.conn == null) {
            this.conn = this.segment.createRealConnection();
            this.realOpenTime = Clock.currTimeMillis + (long)rnd.nextInt(120000);
            this.openStatements.clear();
            this.reopenAttempts = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void logicalClose(boolean withTest) throws SQLException {
        this.openTime = 0L;
        if (this.debug) {
            this.lastTrace = null;
        }
        if (this.logicalCloseException != null) {
            Util.throwException(this.logicalCloseException);
        }
        if (withTest) {
            this.conn.setAutoCommit(true);
            if (this.testSQL != null && this.testSQL.length() > 0) {
                ResultSet rs = null;
                Statement stmt = null;
                try {
                    stmt = this.conn.createStatement();
                    rs = stmt.executeQuery(this.testSQL);
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
            }
        }
    }

    private boolean closeStatements() {
        boolean hasUnclosed = false;
        if (this.openStatements.size() > 0) {
            for (Statement stmt : this.openStatements) {
                try {
                    if (stmt.isClosed()) continue;
                    stmt.close();
                    hasUnclosed = true;
                }
                catch (SQLException e) {
                    hasUnclosed = true;
                    this.setLogicalCloseException(e);
                }
                catch (Throwable t) {
                    hasUnclosed = true;
                    if (this.logicalCloseException != null) continue;
                    if (Util.isRuntimeError(t)) {
                        this.setLogicalCloseException(t);
                        continue;
                    }
                    this.setLogicalCloseException(new SQLException(t));
                }
            }
            this.openStatements.clear();
        }
        return hasUnclosed;
    }

    private void setLogicalCloseException(Throwable t) {
        if (this.logicalCloseException == null) {
            this.logicalCloseException = t;
        } else if (!Util.isRuntimeError(this.logicalCloseException) && Util.isRuntimeError(t)) {
            this.logicalCloseException = t;
        }
    }

    final void forceRealClose() {
        this.forceRealClose(this.forceRealClosePolicy);
    }

    final void forceRealClose(ForceRealClosePolicy policy) {
        if (this.conn != null) {
            this.transactionState = TransactionState.CLOSED;
            if (policy == ForceRealClosePolicy.STATEMENTS_AND_CONNECTION) {
                for (Statement stmt : this.openStatements) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            if (policy != ForceRealClosePolicy.NONE) {
                if (policy == ForceRealClosePolicy.CONNECTION_WITH_LIMIT) {
                    try {
                        closeTimeLimiter.callWithTimeout((Callable)new Callable<Boolean>(){

                            @Override
                            public Boolean call() throws Exception {
                                ConnectionPoolConnection.this.conn.close();
                                return Boolean.TRUE;
                            }
                        }, this.closeTimeLimitMillis, TimeUnit.MILLISECONDS, true);
                    }
                    catch (UncheckedTimeoutException ute) {
                        this.segment.logError("Unable to close connection after waiting " + this.closeTimeLimitMillis + " ms");
                    }
                    catch (Exception e) {
                        this.segment.logError("Connection close error", e);
                    }
                } else {
                    try {
                        this.conn.close();
                    }
                    catch (Exception e) {
                        this.segment.logError("Connection close error", e);
                    }
                }
            }
            this.conn = null;
            this.realOpenTime = Long.MAX_VALUE;
            this.reopenAttempts = 0;
            this.lastTrace = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void resolveIncompleteTransactions() throws SQLException {
        block11: {
            switch (this.transactionState) {
                case COMPLETED: {
                    return;
                }
                case STARTED: {
                    if (this.conn == null || this.openStatements.size() <= 0) return;
                    switch (this.incompleteTransactionPolicy) {
                        case REPORT: {
                            throw new SQLException("Statement closed with incomplete transaction", "25000");
                        }
                        case COMMIT: {
                            if (this.conn.isClosed()) return;
                            this.conn.commit();
                            break block11;
                        }
                        case ROLLBACK: {
                            if (this.conn.isClosed()) return;
                            this.conn.rollback();
                        }
                    }
                }
            }
        }
    }

    String getTrace() {
        return this.lastTrace;
    }

    private void openStatement(Statement stmt) {
        switch (this.openStatementPolicy) {
            case NONE: {
                break;
            }
            default: {
                this.openStatements.add(stmt);
            }
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Statements may not be created after connection close", "08000");
        }
        if (this.debug) {
            this.lastTrace = Util.getFilteredStack();
        }
        Statement stmt = this.conn.createStatement();
        this.openStatement(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Statements may not be created after connection close", "08000");
        }
        if (this.debug) {
            this.lastTrace = Util.getFilteredStack();
        }
        PreparedStatement stmt = this.conn.prepareStatement(sql);
        this.openStatement(stmt);
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Statements may not be created after connection close", "08000");
        }
        if (this.debug) {
            this.lastTrace = Util.getFilteredStack();
        }
        CallableStatement stmt = this.conn.prepareCall(sql);
        this.openStatement(stmt);
        return stmt;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Operation not permitted on closed connection", "08000");
        }
        return this.conn.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Operation not permitted on closed connection", "08000");
        }
        this.conn.setAutoCommit(autoCommit);
        if (!autoCommit) {
            switch (this.transactionState) {
                case NONE: {
                    this.transactionState = TransactionState.STARTED;
                    break;
                }
                default: {
                    this.transactionState = TransactionState.COMPLETED;
                    break;
                }
            }
        } else if (this.transactionState != TransactionState.NONE) {
            this.transactionState = TransactionState.COMPLETED;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Operation not permitted on closed connection", "08000");
        }
        this.conn.commit();
        this.transactionState = TransactionState.COMPLETED;
    }

    @Override
    public void rollback() throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Operation not permitted on closed connection", "08000");
        }
        this.conn.rollback();
        this.transactionState = TransactionState.COMPLETED;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.transactionState == TransactionState.CLOSED;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Operation not permitted on closed connection", "08000");
        }
        return this.conn.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.conn.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.conn.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Statements may not be created after connection close", "08000");
        }
        if (this.debug) {
            this.lastTrace = Util.getFilteredStack();
        }
        Statement stmt = this.conn.createStatement(resultSetType, resultSetConcurrency);
        this.openStatement(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Statements may not be created after connection close", "08000");
        }
        if (this.debug) {
            this.lastTrace = Util.getFilteredStack();
        }
        PreparedStatement stmt = this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
        this.openStatement(stmt);
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Statements may not be created after connection close", "08000");
        }
        if (this.debug) {
            this.lastTrace = Util.getFilteredStack();
        }
        CallableStatement stmt = this.conn.prepareCall(sql, resultSetType, resultSetConcurrency);
        this.openStatement(stmt);
        return stmt;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Operation not permitted on closed connection", "08000");
        }
        return this.conn.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Operation not permitted on closed connection", "08000");
        }
        return this.conn.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Operation not permitted on closed connection", "08000");
        }
        return this.conn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Operation not permitted on closed connection", "08000");
        }
        return this.conn.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Operation not permitted on closed connection", "08000");
        }
        this.transactionState = TransactionState.COMPLETED;
        this.conn.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Operation not permitted on closed connection", "08000");
        }
        this.conn.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Statements may not be created after connection close", "08000");
        }
        if (this.debug) {
            this.lastTrace = Util.getFilteredStack();
        }
        Statement stmt = this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.openStatement(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Statements may not be created after connection close", "08000");
        }
        PreparedStatement stmt = this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.openStatement(stmt);
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Statements may not be created after connection close", "08000");
        }
        if (this.debug) {
            this.lastTrace = Util.getFilteredStack();
        }
        CallableStatement stmt = this.conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.openStatement(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Statements may not be created after connection close", "08000");
        }
        if (this.debug) {
            this.lastTrace = Util.getFilteredStack();
        }
        PreparedStatement stmt = this.conn.prepareStatement(sql, autoGeneratedKeys);
        this.openStatement(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Statements may not be created after connection close", "08000");
        }
        if (this.debug) {
            this.lastTrace = Util.getFilteredStack();
        }
        PreparedStatement stmt = this.conn.prepareStatement(sql, columnIndexes);
        this.openStatement(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Statements may not be created after connection close", "08000");
        }
        if (this.debug) {
            this.lastTrace = Util.getFilteredStack();
        }
        PreparedStatement stmt = this.conn.prepareStatement(sql, columnNames);
        this.openStatement(stmt);
        return stmt;
    }

    @Override
    public Clob createClob() throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Statements may not be created after connection close", "08000");
        }
        return this.conn.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Statements may not be created after connection close", "08000");
        }
        return this.conn.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Statements may not be created after connection close", "08000");
        }
        return this.conn.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Statements may not be created after connection close", "08000");
        }
        return this.conn.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.transactionState != TransactionState.CLOSED;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Operation not permitted on closed connection", "08000");
        }
        return this.conn.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Operation not permitted on closed connection", "08000");
        }
        return this.conn.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Operation not permitted on closed connection", "08000");
        }
        return this.conn.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        if (this.transactionState == TransactionState.CLOSED) {
            throw new SQLException("Operation not permitted on closed connection", "08000");
        }
        return this.conn.createStruct(typeName, attributes);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.conn.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.conn.isWrapperFor(iface);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    static enum TransactionState {
        CLOSED,
        NONE,
        STARTED,
        COMPLETED;

    }

    public static enum ActivityTimeoutPolicy {
        FORCE_CLOSE,
        LOG;


        static ActivityTimeoutPolicy fromString(String str, ActivityTimeoutPolicy defaultPolicy) {
            if (str == null) {
                return defaultPolicy;
            }
            if (str.equalsIgnoreCase("force_close") || str.equalsIgnoreCase("forceClose")) {
                return FORCE_CLOSE;
            }
            if (str.equalsIgnoreCase("log")) {
                return LOG;
            }
            return defaultPolicy;
        }
    }

    public static enum OpenStatementPolicy {
        NONE,
        SILENT,
        REPORT;


        static OpenStatementPolicy fromString(String str, OpenStatementPolicy defaultPolicy) {
            if (str == null) {
                return defaultPolicy;
            }
            if (str.equalsIgnoreCase("none")) {
                return NONE;
            }
            if (str.equalsIgnoreCase("silent")) {
                return SILENT;
            }
            if (str.equalsIgnoreCase("report")) {
                return REPORT;
            }
            return defaultPolicy;
        }
    }

    public static enum ForceRealClosePolicy {
        CONNECTION,
        CONNECTION_WITH_LIMIT,
        STATEMENTS_AND_CONNECTION,
        NONE;


        static ForceRealClosePolicy fromString(String str, ForceRealClosePolicy defaultPolicy) {
            if (str == null) {
                return defaultPolicy;
            }
            if (str.equalsIgnoreCase("connection")) {
                return CONNECTION;
            }
            if (str.equalsIgnoreCase("statements_and_connection") || str.equalsIgnoreCase("statementsAndConnection")) {
                return STATEMENTS_AND_CONNECTION;
            }
            if (str.equalsIgnoreCase("none")) {
                return NONE;
            }
            if (str.equalsIgnoreCase("connection_with_limit") || str.equalsIgnoreCase("connectionWithLimit")) {
                return CONNECTION_WITH_LIMIT;
            }
            return defaultPolicy;
        }
    }

    public static enum IncompleteTransactionPolicy {
        REPORT,
        COMMIT,
        ROLLBACK;


        static IncompleteTransactionPolicy fromString(String str, IncompleteTransactionPolicy defaultPolicy) {
            if (str == null) {
                return defaultPolicy;
            }
            if (str.equalsIgnoreCase("report")) {
                return REPORT;
            }
            if (str.equalsIgnoreCase("commit")) {
                return COMMIT;
            }
            if (str.equalsIgnoreCase("rollback")) {
                return ROLLBACK;
            }
            return defaultPolicy;
        }
    }
}

