/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.sql.pool;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.attribyte.api.InitializationException;
import org.attribyte.api.Logger;
import org.attribyte.essem.metrics.Timer;
import org.attribyte.sql.ConnectionSupplier;
import org.attribyte.sql.pool.Clock;
import org.attribyte.sql.pool.ConnectionPoolConnection;
import org.attribyte.sql.pool.ConnectionPoolSegment;
import org.attribyte.sql.pool.PasswordSource;
import org.attribyte.sql.pool.TypesafeConfig;
import org.attribyte.sql.pool.Util;

public class ConnectionPool
implements ConnectionSupplier {
    private final Logger logger;
    private final String name;
    private final ImmutableSet<String> aka;
    private final int minActiveSegments;
    private final long minSegmentExpansionDelayMillis;
    private final ConnectionPoolSegment[] segments;
    private volatile int activeSegments;
    private final ScheduledExecutorService idleSegmentMonitorService;
    private final ScheduledExecutorService inactiveMonitorService;
    private final Thread segmentSignalMonitorThread;
    private final ArrayBlockingQueue<Object> segmentSignalQueue;
    private final Timer acquisitions;
    private final Meter failedAcquisitions;
    private final Gauge<Integer> activeSegmentsGauge;
    private final Gauge<Long> segmentExpansionGauge;
    private final Gauge<Float> activeConnectionUtilizationGauge;
    private final Gauge<Float> availableConnectionUtilizationGauge;
    private final MetricSet metrics;
    private final AtomicLong segmentExpansions = new AtomicLong(0L);
    private final Counter activeUnmanagedConnections;
    private static final Object ACTIVATE_SEGMENT_SIGNAL = new Object();
    private static final Object DEACTIVATE_SEGMENT_SIGNAL = new Object();
    private static final Object IDLE_SEGMENT_CHECK_SIGNAL = new Object();
    private final String SATURATED_MESSAGE;
    final long saturatedAcquireTimeoutMillis;
    final String connectionDescription;
    final int maxConnections;
    private final AtomicBoolean isShuttingDown = new AtomicBoolean(false);

    public static Initializer newInitializer() {
        return new Initializer();
    }

    private ConnectionPool(String name, Collection<String> aka, List<ConnectionPoolSegment> activeSegments, List<ConnectionPoolSegment> reserveSegments, long saturatedAcquireTimeoutMillis, int minActiveSegments, long idleCheckIntervalMillis, long minSegmentExpansionDelayMillis, Logger logger) throws SQLException, InitializationException {
        this.name = name;
        this.aka = aka != null ? ImmutableSet.copyOf(aka) : ImmutableSet.of();
        this.acquisitions = new Timer();
        this.failedAcquisitions = new Meter();
        this.activeUnmanagedConnections = new Counter();
        this.activeSegmentsGauge = new Gauge<Integer>(){

            public Integer getValue() {
                return ConnectionPool.this.activeSegments;
            }
        };
        this.segmentExpansionGauge = new Gauge<Long>(){

            public Long getValue() {
                return ConnectionPool.this.segmentExpansions.get();
            }
        };
        this.activeConnectionUtilizationGauge = new Gauge<Float>(){

            public Float getValue() {
                int avail = ConnectionPool.this.getAvailableConnections();
                int active = ConnectionPool.this.getActiveConnections();
                if (active >= avail) {
                    return Float.valueOf(1.0f);
                }
                return Float.valueOf((float)active / (float)avail);
            }
        };
        this.availableConnectionUtilizationGauge = new Gauge<Float>(){

            public Float getValue() {
                int max = ConnectionPool.this.getMaxConnections();
                int active = ConnectionPool.this.getActiveConnections();
                if (active >= max) {
                    return Float.valueOf(1.0f);
                }
                return Float.valueOf((float)active / (float)max);
            }
        };
        this.metrics = new MetricSet(){

            public Map<String, Metric> getMetrics() {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.put((Object)"acquisitions", (Object)ConnectionPool.this.acquisitions);
                builder.put((Object)"failed-acquisitions", (Object)ConnectionPool.this.failedAcquisitions);
                builder.put((Object)"active-unmanaged-connections", (Object)ConnectionPool.this.activeUnmanagedConnections);
                builder.put((Object)"active-segments", (Object)ConnectionPool.this.activeSegmentsGauge);
                builder.put((Object)"segment-expansions", (Object)ConnectionPool.this.segmentExpansionGauge);
                builder.put((Object)"active-connections-utilized", (Object)ConnectionPool.this.activeConnectionUtilizationGauge);
                builder.put((Object)"available-connections-utilized", (Object)ConnectionPool.this.availableConnectionUtilizationGauge);
                return builder.build();
            }
        };
        this.SATURATED_MESSAGE = "Connection pool '" + name + "' is saturated";
        this.logger = logger;
        ArrayList segments = Lists.newArrayList(activeSegments);
        if (reserveSegments != null) {
            segments.addAll(reserveSegments);
        }
        HashSet segmentSet = Sets.newHashSet();
        for (ConnectionPoolSegment segment : segments) {
            if (segment == null) {
                this.throwInitException("A null segment was detected in the segment list");
                continue;
            }
            if (segmentSet.contains(segment)) {
                this.throwInitException("Segments must be unique in the segment list");
                continue;
            }
            segmentSet.add(segment);
        }
        int maxSegments = segments.size();
        if (minActiveSegments > segments.size()) {
            this.throwInitException("The 'minActiveSegments' must be <= the total number of segments");
        }
        if (minActiveSegments < 1) {
            this.throwInitException("The 'minActiveSegments' must be >= 1");
        }
        this.minActiveSegments = minActiveSegments;
        this.minSegmentExpansionDelayMillis = minSegmentExpansionDelayMillis;
        this.segments = new ConnectionPoolSegment[maxSegments];
        int pos = 0;
        for (ConnectionPoolSegment connectionPoolSegment : segments) {
            this.segments[pos++] = connectionPoolSegment;
        }
        this.saturatedAcquireTimeoutMillis = saturatedAcquireTimeoutMillis;
        this.activeSegments = activeSegments.size();
        for (ConnectionPoolSegment connectionPoolSegment : activeSegments) {
            try {
                connectionPoolSegment.activate();
            }
            catch (SQLException se) {
                throw new InitializationException("Problem activating segment '" + connectionPoolSegment.name + "' in pool '" + name + "'", (Throwable)se);
            }
        }
        if (this.segments.length > 1 && this.minActiveSegments != this.segments.length) {
            this.segmentSignalQueue = new ArrayBlockingQueue(1);
            String signalMonitorThreadName = Strings.isNullOrEmpty((String)name) ? "SignalMonitor" : name + ":SignalMonitor";
            this.segmentSignalMonitorThread = new Thread((Runnable)new SegmentSignalMonitor(), "ACP:" + signalMonitorThreadName);
            this.segmentSignalMonitorThread.start();
            this.idleSegmentMonitorService = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(1, Util.createThreadFactoryBuilder(name, "IdleMonitor")));
            this.idleSegmentMonitorService.scheduleWithFixedDelay(new IdleSegmentMonitor(), idleCheckIntervalMillis, idleCheckIntervalMillis, TimeUnit.MILLISECONDS);
        } else {
            this.segmentSignalQueue = null;
            this.segmentSignalMonitorThread = null;
            this.idleSegmentMonitorService = null;
        }
        this.inactiveMonitorService = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(1, Util.createThreadFactoryBuilder(name, "InactiveMonitor")));
        this.connectionDescription = this.buildConnectionDescription();
        int maxCount = 0;
        for (ConnectionPoolSegment segment : segments) {
            maxCount += segment.getMaxConnections();
        }
        this.maxConnections = maxCount;
        StringBuilder stringBuilder = new StringBuilder("Created with ");
        stringBuilder.append(activeSegments.size()).append(activeSegments.size() == 1 ? " active segment, " : " active segments, ");
        stringBuilder.append(reserveSegments == null ? 0 : reserveSegments.size()).append(reserveSegments == null || reserveSegments.size() > 1 ? " reserve segments, " : " reserve segment, ");
        stringBuilder.append(minActiveSegments).append(" always active");
        this.logInfo(stringBuilder.toString());
    }

    public final Connection getUnmanagedConnection() throws SQLException {
        this.activeUnmanagedConnections.inc();
        return this.segments[0].createRealConnection();
    }

    public final void closeUnmanagedConnection(Connection conn) throws SQLException {
        this.activeUnmanagedConnections.dec();
        if (!conn.isClosed()) {
            conn.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Connection getConnection() throws SQLException {
        Timer.Context ctx = this.acquisitions.time();
        try {
            ConnectionPoolConnection conn;
            int i;
            for (i = 0; i < this.activeSegments; ++i) {
                conn = this.segments[i].open();
                if (conn == null) continue;
                ConnectionPoolConnection connectionPoolConnection = conn;
                return connectionPoolConnection;
            }
            this.signalActivateSegment();
            try {
                for (i = 0; i < this.activeSegments; ++i) {
                    ConnectionPoolSegment segment = this.segments[i];
                    conn = segment.open(segment.acquireTimeoutMillis, TimeUnit.MILLISECONDS);
                    if (conn == null) continue;
                    ConnectionPoolConnection connectionPoolConnection = conn;
                    return connectionPoolConnection;
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new SQLException("Connection pool, '" + this.name + "' interrupted during acquire", "08000");
            }
            long maxTimeoutMillis = this.saturatedAcquireTimeoutMillis / (long)this.activeSegments;
            try {
                for (int i2 = 0; i2 < this.activeSegments; ++i2) {
                    ConnectionPoolSegment segment = this.segments[i2];
                    conn = segment.open(maxTimeoutMillis, TimeUnit.MILLISECONDS);
                    if (conn == null) continue;
                    ConnectionPoolConnection connectionPoolConnection = conn;
                    return connectionPoolConnection;
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new SQLException("Connection pool, '" + this.name + "' interrupted during acquire", "08000");
            }
            this.failedAcquisitions.mark();
            throw new SQLException(this.SATURATED_MESSAGE, "08006");
        }
        finally {
            ctx.stop();
        }
    }

    public final ListenableFuture<Connection> getFutureConnection(ListeningExecutorService executor) {
        return executor.submit(this::getConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void signalActivateSegment() throws SQLException {
        if (this.segmentSignalQueue != null) {
            this.segmentSignalQueue.offer(ACTIVATE_SEGMENT_SIGNAL);
        } else if (this.activeSegments == 0) {
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                if (this.activeSegments == 0) {
                    this.segments[0].activate();
                    this.activeSegments = 1;
                }
            }
        }
    }

    public final void shutdown() {
        if (this.isShuttingDown.compareAndSet(false, true)) {
            this.logInfo("Shutting down...");
            if (this.idleSegmentMonitorService != null) {
                this.logInfo("Shutting down idle segment monitor service...");
                this.idleSegmentMonitorService.shutdownNow();
            }
            if (this.segmentSignalQueue != null) {
                this.segmentSignalQueue.clear();
            }
            if (this.segmentSignalMonitorThread != null) {
                this.logInfo("Shutting down segment signal monitor thread...");
                this.segmentSignalMonitorThread.interrupt();
            }
            this.logInfo("Shutting down all segments...");
            for (ConnectionPoolSegment segment : this.segments) {
                segment.shutdown();
            }
            this.logInfo("Shutting down inactive monitor service...");
            this.inactiveMonitorService.shutdownNow();
            Clock.shutdown();
            this.logInfo("Shut down");
        }
    }

    public String getName() {
        return this.name;
    }

    public ImmutableSet<String> getAKA() {
        return this.aka;
    }

    public int getActiveSegments() {
        return this.activeSegments;
    }

    public int getTotalSegments() {
        return this.segments.length;
    }

    public int getMinActiveSegments() {
        return this.minActiveSegments;
    }

    private int getMaxConnections() {
        return this.maxConnections;
    }

    public int getActiveConnections() {
        int count = 0;
        for (ConnectionPoolSegment segment : this.segments) {
            count += segment.getActiveConnectionCount();
        }
        return count;
    }

    public int getAvailableConnections() {
        int count = 0;
        for (ConnectionPoolSegment segment : this.segments) {
            count += segment.getAvailableConnectionCount();
        }
        return count;
    }

    public boolean isIdle() {
        for (ConnectionPoolSegment segment : this.segments) {
            if (segment.isIdle()) continue;
            return false;
        }
        return true;
    }

    public Stats getStats() {
        return new Stats(this);
    }

    public MetricSet getMetrics() {
        return this.metrics;
    }

    public MetricRegistry registerMetrics(MetricRegistry registry) {
        registry.register(MetricRegistry.name(ConnectionPool.class, (String[])new String[]{this.name}), (Metric)this.metrics);
        return registry;
    }

    final ConnectionPoolSegment[] getSegmentsForTest() {
        return this.segments;
    }

    private void logInfo(String message) {
        if (this.logger != null) {
            StringBuilder buf = new StringBuilder(this.name);
            buf.append(":");
            buf.append(message);
            this.logger.info(buf.toString());
        }
    }

    private void logError(String message, Throwable t) {
        if (this.logger != null) {
            StringBuilder buf = new StringBuilder(this.name);
            buf.append(":");
            buf.append(message);
            this.logger.error(buf.toString(), t);
        }
    }

    private void throwInitException(String message) throws InitializationException {
        this.logError(message, null);
        throw new InitializationException(message);
    }

    private String buildConnectionDescription() {
        ArrayList descList = Lists.newArrayListWithExpectedSize((int)4);
        for (ConnectionPoolSegment segment : this.segments) {
            String desc = segment.dbConnection.getConnectionDescription();
            if (descList.contains(desc)) continue;
            descList.add(desc);
        }
        return Joiner.on((char)',').join((Iterable)descList);
    }

    void setDataSourceLogWriter(PrintWriter writer) throws SQLException {
        for (ConnectionPoolSegment segment : this.segments) {
            if (segment.dbConnection.datasource == null) continue;
            segment.dbConnection.datasource.setLogWriter(writer);
        }
    }

    void setDataSourceLoginTimeout(int seconds) throws SQLException {
        for (ConnectionPoolSegment segment : this.segments) {
            if (segment.dbConnection.datasource == null) continue;
            segment.dbConnection.datasource.setLoginTimeout(seconds);
        }
    }

    private final class SegmentSignalMonitor
    implements Runnable {
        private long lastActivateTime = System.currentTimeMillis();
        private long lastSegmentIdleStart;

        private SegmentSignalMonitor() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    Object signal;
                    if ((signal = ConnectionPool.this.segmentSignalQueue.take()) == ACTIVATE_SEGMENT_SIGNAL && ConnectionPool.this.activeSegments < ConnectionPool.this.segments.length) {
                        if (this.lastActivateTime != 0L && System.currentTimeMillis() - this.lastActivateTime <= ConnectionPool.this.minSegmentExpansionDelayMillis) continue;
                        try {
                            ConnectionPool.this.segments[ConnectionPool.this.activeSegments].activate();
                            ConnectionPool.this.activeSegments++;
                            this.lastActivateTime = System.currentTimeMillis();
                            this.lastSegmentIdleStart = 0L;
                            ConnectionPool.this.segmentExpansions.incrementAndGet();
                            ConnectionPool.this.logInfo("Activated segment " + ((ConnectionPool)ConnectionPool.this).segments[((ConnectionPool)ConnectionPool.this).activeSegments - 1].name);
                        }
                        catch (SQLException se) {
                            ConnectionPool.this.logError("Problem activating segment", se);
                            ConnectionPool.this.segments[ConnectionPool.this.activeSegments].deactivate();
                        }
                        continue;
                    }
                    if (ConnectionPool.this.activeSegments <= ConnectionPool.this.minActiveSegments) continue;
                    if (signal == DEACTIVATE_SEGMENT_SIGNAL) {
                        ConnectionPoolSegment toDeactivate = ConnectionPool.this.segments[--ConnectionPool.this.activeSegments];
                        ConnectionPool.this.logInfo("Deactivated segment " + toDeactivate.name);
                        boolean deactivated = toDeactivate.deactivate();
                        if (!deactivated) {
                            toDeactivate.deactivateNow();
                        }
                        this.lastSegmentIdleStart = 0L;
                        continue;
                    }
                    if (signal != IDLE_SEGMENT_CHECK_SIGNAL) continue;
                    ConnectionPoolSegment lastActiveSegment = ConnectionPool.this.segments[ConnectionPool.this.activeSegments - 1];
                    long currentTimeMillis = System.currentTimeMillis();
                    if (lastActiveSegment.isIdle()) {
                        if (this.lastSegmentIdleStart == 0L) {
                            this.lastSegmentIdleStart = currentTimeMillis;
                            continue;
                        }
                        if (currentTimeMillis - this.lastSegmentIdleStart <= lastActiveSegment.idleTimeBeforeShutdownMillis || currentTimeMillis - this.lastActivateTime <= lastActiveSegment.minActiveTimeMillis) continue;
                        ConnectionPool.this.segmentSignalQueue.offer(DEACTIVATE_SEGMENT_SIGNAL);
                        continue;
                    }
                    this.lastSegmentIdleStart = 0L;
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Throwable t) {
                ConnectionPool.this.logError("Unable to perform segment operation", t);
            }
        }
    }

    private final class IdleSegmentMonitor
    implements Runnable {
        private IdleSegmentMonitor() {
        }

        @Override
        public void run() {
            ConnectionPool.this.segmentSignalQueue.offer(IDLE_SEGMENT_CHECK_SIGNAL);
        }
    }

    public static class Initializer {
        String name;
        final Set<String> aka = Sets.newHashSet();
        final List<ConnectionPoolSegment> activeSegments = Lists.newArrayListWithExpectedSize((int)4);
        final List<ConnectionPoolSegment> reserveSegments = Lists.newArrayListWithExpectedSize((int)4);
        int minActiveSegments;
        long minSegmentExpansionDelayMillis = 1000L;
        long saturatedAcquireTimeoutMillis;
        long idleCheckIntervalMillis = 60000L;
        Logger logger;

        public static final List<Initializer> fromConfig(Config config, PasswordSource passwordSource, Logger logger) throws InitializationException {
            return TypesafeConfig.poolsFromConfig(config, passwordSource, logger);
        }

        public static final List<Initializer> fromConfigFile(File configFile, PasswordSource passwordSource, Logger logger) throws InitializationException {
            Config rootConfig = ConfigFactory.parseFile((File)configFile);
            return Initializer.fromConfig(rootConfig.getConfig("acp"), passwordSource, logger);
        }

        public static final List<Initializer> fromProperties(Properties props, PasswordSource passwordSource, Logger logger) throws InitializationException {
            Config rootConfig = ConfigFactory.parseProperties((Properties)props);
            return Initializer.fromConfig(rootConfig, passwordSource, logger);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final List<Initializer> fromPropertiesFile(File propsFile, PasswordSource passwordSource, Logger logger) throws InitializationException {
            Properties props = new Properties();
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(propsFile);
                    props.load(fis);
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                }
            }
            catch (IOException ioe) {
                throw new InitializationException("Problem loading properties", (Throwable)ioe);
            }
            return Initializer.fromProperties(props, passwordSource, logger);
        }

        public Initializer setName(String name) {
            this.name = name;
            return this;
        }

        public Initializer addActiveSegment(ConnectionPoolSegment segment) {
            this.activeSegments.add(segment);
            return this;
        }

        public Initializer addActiveSegments(List<ConnectionPoolSegment> segments) {
            this.activeSegments.addAll(segments);
            return this;
        }

        public Initializer addReserveSegment(ConnectionPoolSegment segment) {
            this.reserveSegments.add(segment);
            return this;
        }

        public Initializer addReserveSegments(List<ConnectionPoolSegment> segments) {
            this.reserveSegments.addAll(segments);
            return this;
        }

        public Initializer setMinActiveSegments(int minActiveSegments) {
            this.minActiveSegments = minActiveSegments;
            return this;
        }

        public Initializer setMinSegmentExpansionDelay(long minSegmentExpansionDelayMillis) {
            this.minSegmentExpansionDelayMillis = minSegmentExpansionDelayMillis;
            return this;
        }

        public Initializer setIdleCheckInterval(long idleCheckInterval, TimeUnit idleCheckIntervalUnit) {
            this.idleCheckIntervalMillis = TimeUnit.MILLISECONDS.convert(idleCheckInterval, idleCheckIntervalUnit);
            return this;
        }

        public Initializer setSaturatedAcquireTimeout(long saturatedAcquireTimeout, TimeUnit saturatedAcquireTimeoutUnit) {
            this.saturatedAcquireTimeoutMillis = TimeUnit.MILLISECONDS.convert(saturatedAcquireTimeout, saturatedAcquireTimeoutUnit);
            return this;
        }

        public Initializer setLogger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Initializer addAlias(String alias) {
            this.aka.add(alias);
            return this;
        }

        public ConnectionPool createPool() throws SQLException, InitializationException {
            for (ConnectionPoolSegment segment : this.activeSegments) {
                if (segment.pool == null) continue;
                throw new InitializationException("The segment, '" + segment.name + "' may not be added to multiple pools");
            }
            for (ConnectionPoolSegment segment : this.reserveSegments) {
                if (segment.pool == null) continue;
                throw new InitializationException("The segment, '" + segment.name + "' may not be added to multiple pools");
            }
            ConnectionPool pool = new ConnectionPool(this.name, this.aka, this.activeSegments, this.reserveSegments, this.saturatedAcquireTimeoutMillis, this.minActiveSegments, this.idleCheckIntervalMillis, this.minSegmentExpansionDelayMillis, this.logger);
            for (ConnectionPoolSegment segment : this.activeSegments) {
                segment.pool = pool;
                segment.startActiveTimeoutMonitor(pool.inactiveMonitorService);
            }
            for (ConnectionPoolSegment segment : this.reserveSegments) {
                segment.pool = pool;
                segment.startActiveTimeoutMonitor(pool.inactiveMonitorService);
            }
            return pool;
        }
    }

    public static class Stats {
        private final String poolName;
        private final String connectionDescription;
        private final int activeConnections;
        private final int availableConnections;
        private final int maxConnections;
        private final long createTime = System.currentTimeMillis();
        private final long connectionCount;
        private final long connectionErrorCount;
        private final long activeTimeoutCount;
        private final long failedAcquisitionCount;
        private final long segmentExpansionCount;
        private final long activeUnmanagedConnectionCount;
        private final int activeSegments;
        private final double oneMinuteAcquisitionRate;
        private final double fiveMinuteAcquisitionRate;
        private final double fifteenMinuteAcquisitionRate;
        private final double oneMinuteFailedAcquisitionRate;
        private final double fiveMinuteFailedAcquisitionRate;
        private final double fifteenMinuteFailedAcquisitionRate;

        private Stats(ConnectionPool pool) {
            this.poolName = pool.name;
            this.connectionDescription = pool.connectionDescription;
            long _connectionErrorCount = 0L;
            long _activeTimeoutCount = 0L;
            for (ConnectionPoolSegment segment : pool.segments) {
                _connectionErrorCount += segment.stats.getFailedConnectionErrorCount();
                _activeTimeoutCount += segment.stats.getActiveTimeoutCount();
            }
            this.connectionCount = pool.acquisitions.getCount();
            this.connectionErrorCount = _connectionErrorCount;
            this.activeTimeoutCount = _activeTimeoutCount;
            this.failedAcquisitionCount = pool.failedAcquisitions.getCount();
            this.segmentExpansionCount = pool.segmentExpansions.get();
            this.activeSegments = pool.activeSegments;
            this.activeUnmanagedConnectionCount = pool.activeUnmanagedConnections.getCount();
            this.activeConnections = pool.getActiveConnections();
            this.availableConnections = pool.getAvailableConnections();
            this.maxConnections = pool.getMaxConnections();
            this.oneMinuteAcquisitionRate = pool.acquisitions.getOneMinuteRate();
            this.fiveMinuteAcquisitionRate = pool.acquisitions.getFiveMinuteRate();
            this.fifteenMinuteAcquisitionRate = pool.acquisitions.getFifteenMinuteRate();
            this.oneMinuteFailedAcquisitionRate = pool.failedAcquisitions.getOneMinuteRate();
            this.fiveMinuteFailedAcquisitionRate = pool.failedAcquisitions.getFiveMinuteRate();
            this.fifteenMinuteFailedAcquisitionRate = pool.failedAcquisitions.getFifteenMinuteRate();
        }

        public String getName() {
            return this.poolName;
        }

        public String getConnectionDescription() {
            return this.connectionDescription;
        }

        public float getActiveConnectionUtilization() {
            if (this.activeConnections >= this.availableConnections) {
                return 1.0f;
            }
            return (float)this.activeConnections / (float)this.availableConnections;
        }

        public float getAvailableConnectionUtilization() {
            if (this.activeConnections >= this.maxConnections) {
                return 1.0f;
            }
            return (float)this.activeConnections / (float)this.maxConnections;
        }

        public int getActiveConnections() {
            return this.activeConnections;
        }

        public int getAvailableConnections() {
            return this.availableConnections;
        }

        public int getMaxConnections() {
            return this.maxConnections;
        }

        public long getTimestamp() {
            return this.createTime;
        }

        public long getConnectionCount() {
            return this.connectionCount;
        }

        public long getFailedConnectionErrorCount() {
            return this.connectionErrorCount;
        }

        public long getActiveTimeoutCount() {
            return this.activeTimeoutCount;
        }

        public long getFailedAcquisitionCount() {
            return this.failedAcquisitionCount;
        }

        public long getSegmentExpansionCount() {
            return this.segmentExpansionCount;
        }

        public long getActiveUnmanagedConnectionCount() {
            return this.activeUnmanagedConnectionCount;
        }

        public int getActiveSegments() {
            return this.activeSegments;
        }

        public TimeUnit getAcquisitionRateUnit() {
            return TimeUnit.SECONDS;
        }

        public double getOneMinuteAcquisitionRate() {
            return this.oneMinuteAcquisitionRate;
        }

        public double getFiveMinuteAcquisitionRate() {
            return this.fiveMinuteAcquisitionRate;
        }

        public double getFifteenMinuteAcquisitionRate() {
            return this.fifteenMinuteAcquisitionRate;
        }

        public double getOneMinuteFailedAcquisitionRate() {
            return this.oneMinuteFailedAcquisitionRate;
        }

        public double getFiveMinuteFailedAcquisitionRate() {
            return this.fiveMinuteFailedAcquisitionRate;
        }

        public double getFifteenMinuteFailedAcquisitionRate() {
            return this.fifteenMinuteFailedAcquisitionRate;
        }
    }
}

