/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.sql.pool;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.attribyte.api.ConsoleLogger;
import org.attribyte.api.InitializationException;
import org.attribyte.api.Logger;
import org.attribyte.sql.pool.Clock;
import org.attribyte.sql.pool.ConnectionPool;
import org.attribyte.sql.pool.ConnectionPoolConnection;
import org.attribyte.sql.pool.JDBConnection;
import org.attribyte.sql.pool.PasswordSource;
import org.attribyte.sql.pool.Util;

public class ConnectionPoolSegment {
    private static final long createTime = System.currentTimeMillis();
    final long acquireTimeoutMillis;
    final long idleTimeBeforeShutdownMillis;
    final long minActiveTimeMillis;
    final boolean testOnLogicalOpen;
    final boolean testOnLogicalClose;
    final String name;
    private final Logger logger;
    final long activeTimeoutMillis;
    final long connectionLifetimeMillis;
    final JDBConnection dbConnection;
    private final ConnectionPoolConnection[] connections;
    private final BlockingQueue<ConnectionPoolConnection> closeQueue;
    private final BlockingQueue<ConnectionPoolConnection> availableQueue;
    private final Thread[] closerThreads;
    private final Closer closer;
    private final long activeTimeoutMonitorFrequencySeconds;
    private final ConnectionPoolConnection.ActivityTimeoutPolicy activityTimeoutPolicy;
    private final ScheduledThreadPoolExecutor reopenExecutor;
    private final ScheduledExecutorService reopenService;
    private final PasswordSource passwordSource;
    final long maxReconnectDelayMillis;
    private volatile boolean isActive = false;
    final Stats stats = new Stats();
    ConnectionPool pool;
    private static final SimpleTimeLimiter connectionTimeLimiter = new SimpleTimeLimiter();

    public static Initializer defaultInitializer() {
        return ConnectionPoolSegment.newInitializer().setCloseConcurrency(0).setTestOnLogicalOpen(false).setTestOnLogicalClose(false).setIncompleteTransactionOnClosePolicy(ConnectionPoolConnection.IncompleteTransactionPolicy.REPORT).setOpenStatementOnClosePolicy(ConnectionPoolConnection.OpenStatementPolicy.REPORT).setForceRealClosePolicy(ConnectionPoolConnection.ForceRealClosePolicy.CONNECTION_WITH_LIMIT).setActivityTimeoutPolicy(ConnectionPoolConnection.ActivityTimeoutPolicy.LOG).setCloseTimeLimitMillis(10000L).setActiveTimeout(60L, TimeUnit.SECONDS).setConnectionLifetime(15L, TimeUnit.MINUTES).setMaxConcurrentReconnects(2).setMaxReconnectDelay(1L, TimeUnit.MINUTES).setActiveTimeoutMonitorFrequency(30L, TimeUnit.SECONDS);
    }

    public static Initializer newInitializer() {
        return new Initializer();
    }

    private void reopen(ConnectionPoolConnection conn) {
        if (this.isActive) {
            if (conn.reopenAttempts == 0) {
                ++conn.reopenAttempts;
                this.reopenService.execute(new Reopener(conn));
            } else {
                long delayMillis = 100L * (long)conn.reopenAttempts;
                if (delayMillis > this.maxReconnectDelayMillis) {
                    delayMillis = this.maxReconnectDelayMillis;
                }
                ++conn.reopenAttempts;
                this.reopenService.schedule(new Reopener(conn), delayMillis, TimeUnit.MILLISECONDS);
            }
        }
    }

    private ConnectionPoolSegment(String name, int size, long acquireTimeoutMillis, long activeTimeoutMillis, long activeTimeoutMonitorFrequencySeconds, long connectionLifetimeMillis, long idleTimeBeforeShutdownMillis, long minActiveTimeMillis, JDBConnection dbConnection, int numCloserThreads, int maxConcurrentReconnects, long maxReconnectDelayMillis, boolean testOnLogicalOpen, boolean testOnLogicalClose, ConnectionPoolConnection.IncompleteTransactionPolicy incompleteTransactionPolicy, ConnectionPoolConnection.OpenStatementPolicy openStatementPolicy, ConnectionPoolConnection.ForceRealClosePolicy forceRealClosePolicy, ConnectionPoolConnection.ActivityTimeoutPolicy activityTimeoutPolicy, PasswordSource passwordSource, Logger logger, long closeTimeLimitMillis) {
        this.name = name;
        this.acquireTimeoutMillis = acquireTimeoutMillis;
        this.activeTimeoutMillis = activeTimeoutMillis;
        this.connectionLifetimeMillis = connectionLifetimeMillis < 1L ? 3600000L : connectionLifetimeMillis;
        this.idleTimeBeforeShutdownMillis = idleTimeBeforeShutdownMillis;
        this.minActiveTimeMillis = minActiveTimeMillis;
        this.dbConnection = dbConnection;
        this.testOnLogicalOpen = testOnLogicalOpen;
        this.testOnLogicalClose = testOnLogicalClose;
        this.logger = logger;
        this.connections = new ConnectionPoolConnection[size];
        for (int i = 0; i < size; ++i) {
            ConnectionPoolConnection conn = new ConnectionPoolConnection(this, name + ":connection-" + i, dbConnection.testSQL, dbConnection.debug, incompleteTransactionPolicy, openStatementPolicy, forceRealClosePolicy, closeTimeLimitMillis);
            conn.state.set(0);
            this.connections[i] = conn;
        }
        this.activityTimeoutPolicy = activityTimeoutPolicy;
        this.availableQueue = new LinkedTransferQueue<ConnectionPoolConnection>();
        if (numCloserThreads > 0) {
            String closerThreadNameBase = !Strings.isNullOrEmpty((String)name) ? "ACP:" + name + ":" : "ACP:";
            this.closeQueue = new LinkedTransferQueue<ConnectionPoolConnection>();
            this.closerThreads = new Thread[numCloserThreads];
            for (int i = 0; i < this.closerThreads.length; ++i) {
                this.closerThreads[i] = new Thread((Runnable)new Closer(), closerThreadNameBase + "Closer-" + i);
                this.closerThreads[i].start();
            }
            this.closer = null;
        } else {
            this.closeQueue = null;
            this.closerThreads = new Thread[0];
            this.closer = new Closer();
        }
        this.activeTimeoutMonitorFrequencySeconds = activeTimeoutMonitorFrequencySeconds;
        this.reopenExecutor = new ScheduledThreadPoolExecutor(maxConcurrentReconnects == 0 ? 1 : maxConcurrentReconnects, Util.createThreadFactoryBuilder(name, "Reopener"));
        this.reopenExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.reopenExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.reopenService = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)this.reopenExecutor);
        this.maxReconnectDelayMillis = maxReconnectDelayMillis;
        this.passwordSource = passwordSource;
        this.logInfo("Created with " + size + " connections, saturated pool wait " + acquireTimeoutMillis + " ms");
        this.logInfo("Connection: " + dbConnection.toString());
    }

    final void startActiveTimeoutMonitor(ScheduledExecutorService inactiveMonitorService) {
        inactiveMonitorService.scheduleWithFixedDelay(new ActiveTimeoutMonitor(), this.activeTimeoutMonitorFrequencySeconds, this.activeTimeoutMonitorFrequencySeconds, TimeUnit.SECONDS);
    }

    final void close(ConnectionPoolConnection conn) {
        if (this.closeQueue != null) {
            this.closeQueue.add(conn);
        } else {
            this.closer.close(conn);
        }
    }

    final ConnectionPoolConnection open(long timeout, TimeUnit timeoutUnit) throws InterruptedException {
        ConnectionPoolConnection conn;
        ConnectionPoolConnection connectionPoolConnection = conn = timeout >= 0L ? this.availableQueue.poll(timeout, timeoutUnit) : this.availableQueue.take();
        if (conn != null) {
            if (!this.testOnLogicalOpen) {
                conn.logicalOpen();
                conn.state.set(1);
            } else {
                try {
                    conn.logicalOpenWithTest();
                    conn.state.set(1);
                }
                catch (SQLException se) {
                    conn.state.set(3);
                    this.stats.connectionErrors.mark();
                    this.reopen(conn);
                    return this.open();
                }
            }
        }
        return conn;
    }

    final ConnectionPoolConnection open() {
        ConnectionPoolConnection conn = (ConnectionPoolConnection)this.availableQueue.poll();
        if (conn != null) {
            if (!this.testOnLogicalOpen) {
                conn.logicalOpen();
                conn.state.set(1);
            } else {
                try {
                    conn.logicalOpenWithTest();
                    conn.state.set(1);
                }
                catch (SQLException se) {
                    conn.state.set(3);
                    this.stats.connectionErrors.mark();
                    this.reopen(conn);
                    return this.open();
                }
            }
        }
        return conn;
    }

    final long getActiveTimeoutMonitorFrequencySeconds() {
        return this.activeTimeoutMonitorFrequencySeconds;
    }

    final int getCloserThreadCount() {
        return this.closerThreads.length;
    }

    final int getMaxConcurrentReconnects() {
        return this.reopenExecutor.getCorePoolSize();
    }

    final Connection createRealConnection() throws SQLException {
        return this.createRealConnection(this.dbConnection.createTimeoutMillis);
    }

    final String getPassword() {
        if (this.passwordSource == null) {
            return this.dbConnection.password;
        }
        String usePassword = this.passwordSource.getPassword(this.dbConnection.name);
        if (!Strings.isNullOrEmpty((String)usePassword)) {
            return usePassword;
        }
        usePassword = this.passwordSource.getPassword(this.dbConnection.connectionString, this.dbConnection.user);
        return !Strings.isNullOrEmpty((String)usePassword) ? usePassword : this.dbConnection.password;
    }

    private Connection createRealConnection(long timeoutMillis) throws SQLException {
        if (timeoutMillis < 1L) {
            Connection conn;
            String usePassword = this.getPassword();
            Connection connection = conn = this.dbConnection.datasource == null ? DriverManager.getConnection(this.dbConnection.connectionString, this.dbConnection.user, usePassword) : this.dbConnection.datasource.getConnection(this.dbConnection.user, usePassword);
            if (conn != null) {
                return conn;
            }
            throw new SQLException("Unable to create connection: driver/datasource returned [null]");
        }
        try {
            return (Connection)connectionTimeLimiter.callWithTimeout((Callable)new Callable<Connection>(){

                @Override
                public Connection call() throws Exception {
                    return ConnectionPoolSegment.this.createRealConnection(0L);
                }
            }, timeoutMillis, TimeUnit.MILLISECONDS, true);
        }
        catch (UncheckedTimeoutException ute) {
            throw new SQLException("Unable to create connection after waiting " + timeoutMillis + " ms");
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException("Unable to create connection: driver/datasource", e);
        }
    }

    final void activate() throws SQLException {
        for (ConnectionPoolConnection conn : this.connections) {
            conn.forceRealClose();
            conn.realOpen();
            conn.logicalClose(true);
        }
        if (this.closeQueue != null) {
            this.closeQueue.clear();
        }
        this.availableQueue.clear();
        this.reopenExecutor.getQueue().clear();
        ArrayList connections = Lists.newArrayListWithCapacity((int)this.connections.length);
        for (ConnectionPoolConnection connection : this.connections) {
            connections.add(connection);
            connection.state.set(0);
        }
        this.isActive = true;
        this.stats.activate();
        this.availableQueue.addAll(connections);
    }

    final boolean isIdle() {
        for (ConnectionPoolConnection conn : this.connections) {
            if (conn.state.get() != 1) continue;
            return false;
        }
        return true;
    }

    final boolean deactivate() throws InterruptedException {
        this.isActive = false;
        this.stats.deactivate();
        this.availableQueue.clear();
        this.reopenExecutor.getQueue().clear();
        long maxWaitMillis = this.activeTimeoutMillis;
        if (maxWaitMillis < 1L) {
            maxWaitMillis = 60000L;
        }
        block0: for (long elapsedWaitMillis = 0L; elapsedWaitMillis < maxWaitMillis; elapsedWaitMillis += 500L) {
            for (ConnectionPoolConnection conn : this.connections) {
                int state = conn.state.get();
                if (state == 1 || state == 2) {
                    Thread.sleep(500L);
                    continue block0;
                }
                conn.forceRealClose();
                conn.state.set(4);
            }
            return true;
        }
        return false;
    }

    final void deactivateNow() {
        this.isActive = false;
        this.stats.deactivate();
        this.availableQueue.clear();
        this.reopenExecutor.getQueue().clear();
        for (ConnectionPoolConnection conn : this.connections) {
            conn.forceRealClose();
            conn.state.set(4);
        }
    }

    public Stats getStats() {
        return this.stats;
    }

    public final int getActiveConnectionCount() {
        if (!this.isActive) {
            return 0;
        }
        int count = 0;
        for (ConnectionPoolConnection conn : this.connections) {
            if (conn.state.get() == 0) continue;
            ++count;
        }
        return count;
    }

    public final int getAvailableConnectionCount() {
        if (!this.isActive) {
            return 0;
        }
        int count = 0;
        for (ConnectionPoolConnection conn : this.connections) {
            if (conn.state.get() != 0) continue;
            ++count;
        }
        return count;
    }

    public int getMaxConnections() {
        return this.connections.length;
    }

    final int getAvailableQueueSize() {
        return this.availableQueue.size();
    }

    final void shutdown() {
        boolean deactivated = false;
        try {
            deactivated = this.deactivate();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        if (!deactivated) {
            this.deactivateNow();
        }
        this.reopenService.shutdownNow();
        for (Thread closerThread : this.closerThreads) {
            closerThread.interrupt();
        }
    }

    void logDebug(String message) {
        if (this.logger != null) {
            try {
                StringBuilder buf = new StringBuilder(this.name);
                buf.append(": ");
                buf.append(message);
                this.logger.debug(buf.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void logInfo(String message) {
        if (this.logger != null) {
            try {
                StringBuilder buf = new StringBuilder(this.name);
                buf.append(": ");
                buf.append(message);
                this.logger.info(buf.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void logError(String message) {
        if (this.logger != null) {
            try {
                StringBuilder buf = new StringBuilder(this.name);
                buf.append(":");
                buf.append(message);
                this.logger.error(buf.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void logError(String message, Throwable t) {
        if (this.logger != null) {
            try {
                StringBuilder buf = new StringBuilder(this.name);
                buf.append(":");
                buf.append(message);
                buf.append(":").append(t.getMessage());
                this.logger.error(buf.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void logErrorWithTrace(String message, Throwable t) {
        if (this.logger != null) {
            try {
                StringBuilder buf = new StringBuilder(this.name);
                buf.append(":");
                buf.append(message);
                this.logger.error(buf.toString(), t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private final class ActiveTimeoutMonitor
    implements Runnable {
        private ActiveTimeoutMonitor() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (!ConnectionPoolSegment.this.isActive) return;
            try {
                long currTimeMillis = System.currentTimeMillis();
                block10: for (ConnectionPoolConnection conn : ConnectionPoolSegment.this.connections) {
                    int state = conn.state.get();
                    switch (state) {
                        case 0: {
                            boolean removed;
                            long elapsedTimeMillis = currTimeMillis - conn.realOpenTime;
                            if (ConnectionPoolSegment.this.connectionLifetimeMillis <= 0L || elapsedTimeMillis <= ConnectionPoolSegment.this.connectionLifetimeMillis || !(removed = ConnectionPoolSegment.this.availableQueue.remove(conn))) continue block10;
                            ConnectionPoolSegment.this.logDebug("Connection lifetime reached for " + conn.id);
                            conn.state.set(3);
                            conn.logicalCloseException = null;
                            ConnectionPoolSegment.this.reopen(conn);
                            continue block10;
                        }
                        case 1: {
                            long elapsedTimeMillis = currTimeMillis - conn.openTime;
                            if (elapsedTimeMillis <= ConnectionPoolSegment.this.activeTimeoutMillis) continue block10;
                            switch (ConnectionPoolSegment.this.activityTimeoutPolicy) {
                                case LOG: {
                                    if (conn.getTrace() != null) {
                                        ConnectionPoolSegment.this.logError("Open connection, '" + conn.id + "' inactive for " + elapsedTimeMillis + " ms. Trace: " + conn.getTrace());
                                    } else {
                                        ConnectionPoolSegment.this.logError("Open connection, '" + conn.id + "' inactive for " + elapsedTimeMillis + " ms.");
                                    }
                                    ConnectionPoolSegment.this.stats.activeTimeoutCount.inc();
                                    break;
                                }
                                case FORCE_CLOSE: {
                                    if (!conn.state.compareAndSet(1, 3)) break;
                                    if (conn.getTrace() != null) {
                                        ConnectionPoolSegment.this.logError("Open connection, '" + conn.id + "' inactive for " + elapsedTimeMillis + " ms. Trace: " + conn.getTrace());
                                    } else {
                                        ConnectionPoolSegment.this.logError("Open connection, '" + conn.id + "' inactive for " + elapsedTimeMillis + " ms.");
                                    }
                                    ConnectionPoolSegment.this.stats.activeTimeoutCount.inc();
                                    conn.logicalCloseException = null;
                                    ConnectionPoolSegment.this.reopen(conn);
                                }
                            }
                            continue block10;
                        }
                    }
                }
                return;
            }
            catch (Throwable t) {
                ConnectionPoolSegment.this.logErrorWithTrace("Unexpected exception in active timeout monitor", t);
            }
        }
    }

    private final class Reopener
    implements Runnable {
        private final ConnectionPoolConnection conn;

        Reopener(ConnectionPoolConnection conn) {
            this.conn = conn;
        }

        @Override
        public void run() {
            if (ConnectionPoolSegment.this.isActive) {
                try {
                    if (this.conn.state.compareAndSet(3, 0)) {
                        this.conn.forceRealClose();
                        try {
                            this.conn.realOpen();
                            ConnectionPoolSegment.this.availableQueue.add(this.conn);
                            ConnectionPoolSegment.this.logDebug("Reopening " + this.conn.id);
                        }
                        catch (SQLException se) {
                            ConnectionPoolSegment.this.stats.connectionErrors.mark();
                            this.conn.state.set(3);
                            ConnectionPoolSegment.this.logError("Failed to reopen " + this.conn.id + " (" + this.conn.reopenAttempts + (this.conn.reopenAttempts == 1 ? " try)" : " tries)"), se);
                            ConnectionPoolSegment.this.reopen(this.conn);
                        }
                    }
                }
                catch (Throwable t) {
                    ConnectionPoolSegment.this.logErrorWithTrace("Unexpected exception while reopening", t);
                }
            }
        }
    }

    private final class Closer
    implements Runnable {
        private Closer() {
        }

        final void close(ConnectionPoolConnection conn) {
            if (conn.state.compareAndSet(1, 2)) {
                ConnectionPoolSegment.this.stats.connections.mark();
                try {
                    long currTimeMillis = Clock.currTimeMillis;
                    if (currTimeMillis - conn.realOpenTime > ConnectionPoolSegment.this.connectionLifetimeMillis) {
                        ConnectionPoolSegment.this.logDebug("Connection lifetime reached for " + conn.id);
                        conn.state.set(3);
                        conn.logicalCloseException = null;
                        ConnectionPoolSegment.this.reopen(conn);
                    } else if (currTimeMillis - conn.lastTestTime > ConnectionPoolSegment.this.dbConnection.testIntervalMillis) {
                        ConnectionPoolSegment.this.logDebug("Performing connection test for " + conn.id);
                        conn.lastTestTime = currTimeMillis;
                        conn.logicalClose(true);
                        conn.state.set(0);
                        ConnectionPoolSegment.this.availableQueue.add(conn);
                    } else {
                        conn.logicalClose(ConnectionPoolSegment.this.testOnLogicalClose);
                        conn.state.set(0);
                        ConnectionPoolSegment.this.availableQueue.add(conn);
                    }
                }
                catch (SQLException se) {
                    conn.state.set(3);
                    conn.logicalCloseException = null;
                    ConnectionPoolSegment.this.stats.connectionErrors.mark();
                    ConnectionPoolSegment.this.logError("Connection test failed for " + conn.id, se);
                    ConnectionPoolSegment.this.reopen(conn);
                }
                catch (Throwable t) {
                    ConnectionPoolSegment.this.logErrorWithTrace("Unexpected exception during close", t);
                    conn.state.set(3);
                    conn.logicalCloseException = null;
                    ConnectionPoolSegment.this.stats.connectionErrors.mark();
                    ConnectionPoolSegment.this.reopen(conn);
                }
            }
        }

        @Override
        public void run() {
            try {
                while (true) {
                    ConnectionPoolConnection conn = (ConnectionPoolConnection)ConnectionPoolSegment.this.closeQueue.take();
                    this.close(conn);
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    public static class Initializer {
        private String name;
        private int size;
        private long acquireTimeoutMillis;
        private long activeTimeoutMillis;
        private long activeTimeoutMonitorFrequencySeconds = 30L;
        private long connectionLifetimeMillis;
        private long idleTimeBeforeShutdownMillis;
        private long minActiveTimeMillis;
        private JDBConnection jdbcConnection;
        private Logger logger;
        private int numCloserThreads = 0;
        private int maxConcurrentReconnects;
        private long maxReconnectDelayMillis;
        private boolean testOnLogicalOpen = false;
        private boolean testOnLogicalClose = false;
        private PasswordSource passwordSource = null;
        private ConnectionPoolConnection.IncompleteTransactionPolicy incompleteTransactionPolicy = ConnectionPoolConnection.IncompleteTransactionPolicy.REPORT;
        private ConnectionPoolConnection.OpenStatementPolicy openStatementPolicy = ConnectionPoolConnection.OpenStatementPolicy.SILENT;
        private ConnectionPoolConnection.ForceRealClosePolicy forceRealClosePolicy = ConnectionPoolConnection.ForceRealClosePolicy.CONNECTION;
        private ConnectionPoolConnection.ActivityTimeoutPolicy activityTimeoutPolicy = ConnectionPoolConnection.ActivityTimeoutPolicy.FORCE_CLOSE;
        private long closeTimeLimitMillis = 5000L;

        public Initializer setName(String name) {
            this.name = name;
            return this;
        }

        public Initializer setLogger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Initializer setSize(int size) {
            this.size = size;
            return this;
        }

        public Initializer setAcquireTimeout(long timeout, TimeUnit timeoutUnit) {
            this.acquireTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeoutUnit);
            return this;
        }

        public Initializer setActiveTimeout(long timeout, TimeUnit timeoutUnit) {
            this.activeTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeoutUnit);
            return this;
        }

        public Initializer setActiveTimeoutMonitorFrequency(long timeout, TimeUnit timeoutUnit) {
            this.activeTimeoutMonitorFrequencySeconds = TimeUnit.SECONDS.convert(timeout, timeoutUnit);
            return this;
        }

        public Initializer setConnectionLifetime(long connectionLife, TimeUnit connectionLifeUnit) {
            this.connectionLifetimeMillis = TimeUnit.MILLISECONDS.convert(connectionLife, connectionLifeUnit);
            return this;
        }

        public Initializer setConnection(JDBConnection jdbcConnection) {
            this.jdbcConnection = jdbcConnection;
            return this;
        }

        public boolean hasConnection() {
            return this.jdbcConnection != null;
        }

        public Initializer setCloseConcurrency(int closerConcurrency) {
            this.numCloserThreads = closerConcurrency;
            return this;
        }

        public Initializer setMaxConcurrentReconnects(int maxConcurrentReconnects) {
            this.maxConcurrentReconnects = maxConcurrentReconnects;
            return this;
        }

        public Initializer setMaxReconnectDelay(long time, TimeUnit timeUnit) {
            this.maxReconnectDelayMillis = TimeUnit.MILLISECONDS.convert(time, timeUnit);
            return this;
        }

        public Initializer setTestOnLogicalOpen(boolean testOnLogicalOpen) {
            this.testOnLogicalOpen = testOnLogicalOpen;
            return this;
        }

        public Initializer setTestOnLogicalClose(boolean testOnLogicalClose) {
            this.testOnLogicalClose = testOnLogicalClose;
            return this;
        }

        public Initializer setIdleTimeBeforeShutdown(long time, TimeUnit timeUnit) {
            this.idleTimeBeforeShutdownMillis = TimeUnit.MILLISECONDS.convert(time, timeUnit);
            return this;
        }

        public Initializer setMinActiveTime(long time, TimeUnit timeUnit) {
            this.minActiveTimeMillis = TimeUnit.MILLISECONDS.convert(time, timeUnit);
            return this;
        }

        public Initializer setPasswordSource(PasswordSource passwordSource) {
            this.passwordSource = passwordSource;
            return this;
        }

        public Initializer setIncompleteTransactionOnClosePolicy(ConnectionPoolConnection.IncompleteTransactionPolicy incompleteTransactionPolicy) {
            this.incompleteTransactionPolicy = incompleteTransactionPolicy;
            return this;
        }

        public Initializer setOpenStatementOnClosePolicy(ConnectionPoolConnection.OpenStatementPolicy openStatementPolicy) {
            this.openStatementPolicy = openStatementPolicy;
            return this;
        }

        public Initializer setForceRealClosePolicy(ConnectionPoolConnection.ForceRealClosePolicy forceRealClosePolicy) {
            this.forceRealClosePolicy = forceRealClosePolicy;
            return this;
        }

        public Initializer setCloseTimeLimitMillis(long closeTimeLimitMillis) {
            this.closeTimeLimitMillis = closeTimeLimitMillis;
            return this;
        }

        public Initializer setActivityTimeoutPolicy(ConnectionPoolConnection.ActivityTimeoutPolicy activityTimeoutPolicy) {
            this.activityTimeoutPolicy = activityTimeoutPolicy;
            return this;
        }

        public ConnectionPoolSegment createSegment() throws InitializationException {
            this.validate(false);
            return new ConnectionPoolSegment(this.name, this.size, this.acquireTimeoutMillis, this.activeTimeoutMillis, this.activeTimeoutMonitorFrequencySeconds, this.connectionLifetimeMillis, this.idleTimeBeforeShutdownMillis, this.minActiveTimeMillis, this.jdbcConnection, this.numCloserThreads, this.maxConcurrentReconnects, this.maxReconnectDelayMillis, this.testOnLogicalOpen, this.testOnLogicalClose, this.incompleteTransactionPolicy, this.openStatementPolicy, this.forceRealClosePolicy, this.activityTimeoutPolicy, this.passwordSource, this.logger, this.closeTimeLimitMillis);
        }

        public void validate(boolean withDefaults) throws InitializationException {
            if (Strings.isNullOrEmpty((String)this.name)) {
                throw new InitializationException("A 'name' is required");
            }
            if (this.jdbcConnection == null) {
                throw new InitializationException("A connection must be specified");
            }
            this.jdbcConnection.validate();
            if (this.size < 1) {
                throw new InitializationException("The 'size' must be > 0");
            }
            if (this.maxConcurrentReconnects < 1) {
                if (withDefaults) {
                    this.maxConcurrentReconnects = this.size;
                } else {
                    throw new InitializationException("The 'maxConcurrentReconnects' must be > 0");
                }
            }
            if (this.logger == null && withDefaults) {
                this.logger = new ConsoleLogger();
            }
        }

        public Initializer() {
        }

        public Initializer(Initializer other) {
            this.size = other.size;
            this.acquireTimeoutMillis = other.acquireTimeoutMillis;
            this.activeTimeoutMillis = other.activeTimeoutMillis;
            this.activeTimeoutMonitorFrequencySeconds = other.activeTimeoutMonitorFrequencySeconds;
            this.connectionLifetimeMillis = other.connectionLifetimeMillis;
            this.idleTimeBeforeShutdownMillis = other.idleTimeBeforeShutdownMillis;
            this.minActiveTimeMillis = other.minActiveTimeMillis;
            this.jdbcConnection = other.jdbcConnection;
            this.logger = other.logger;
            this.numCloserThreads = other.numCloserThreads;
            this.maxConcurrentReconnects = other.maxConcurrentReconnects;
            this.maxReconnectDelayMillis = other.maxReconnectDelayMillis;
            this.testOnLogicalOpen = other.testOnLogicalOpen;
            this.testOnLogicalClose = other.testOnLogicalClose;
            this.passwordSource = other.passwordSource;
            this.incompleteTransactionPolicy = other.incompleteTransactionPolicy;
            this.openStatementPolicy = other.openStatementPolicy;
            this.forceRealClosePolicy = other.forceRealClosePolicy;
            this.closeTimeLimitMillis = other.closeTimeLimitMillis;
            this.activityTimeoutPolicy = other.activityTimeoutPolicy;
        }
    }

    public class Stats
    implements MetricSet {
        private final Map<String, Metric> metrics;
        private final Meter connections = new Meter();
        private final Meter connectionErrors = new Meter();
        private final Counter activeTimeoutCount = new Counter();
        private volatile long lastActivatedTime = 0L;
        private volatile long cumulativeActiveTimeMillis = 0L;
        private volatile long lastDeactivateTime = 0L;
        private final Gauge<Integer> activeGauge = new Gauge<Integer>(){

            public Integer getValue() {
                return Stats.this.active ? 1 : 0;
            }
        };
        private volatile boolean active = false;
        private final Gauge<Double> uptimeActiveFraction = new Gauge<Double>(){

            public Double getValue() {
                return Stats.this.getUptimeActiveFraction();
            }
        };

        private Stats() {
            this.metrics = ImmutableMap.builder().put((Object)"connections", (Object)this.connections).put((Object)"connection-errors", (Object)this.connectionErrors).put((Object)"active-timeout", (Object)this.activeTimeoutCount).put((Object)"uptime-active-fraction", this.uptimeActiveFraction).put((Object)"active", this.activeGauge).build();
        }

        public Map<String, Metric> getMetrics() {
            return this.metrics;
        }

        public String getSegmentName() {
            return ConnectionPoolSegment.this.name;
        }

        public long getConnectionCount() {
            return this.connections.getCount();
        }

        public long getFailedConnectionErrorCount() {
            return this.connectionErrors.getCount();
        }

        public long getActiveTimeoutCount() {
            return this.activeTimeoutCount.getCount();
        }

        public long getLastActivatedTime() {
            return this.lastActivatedTime;
        }

        public long getCumulativeActiveTimeMillis() {
            return this.cumulativeActiveTimeMillis;
        }

        public long getLastDeactivateTime() {
            return this.lastDeactivateTime;
        }

        public boolean isActive() {
            return this.active;
        }

        public final double getUptimeActiveFraction() {
            if (this.active && this.cumulativeActiveTimeMillis == 0L) {
                return 1.0;
            }
            long totalTimeMillis = System.currentTimeMillis() - createTime;
            return (double)this.cumulativeActiveTimeMillis / (double)totalTimeMillis;
        }

        private void activate() {
            this.active = true;
            this.lastActivatedTime = System.currentTimeMillis();
        }

        private void deactivate() {
            long currTime;
            this.active = false;
            this.lastDeactivateTime = currTime = System.currentTimeMillis();
            long activeTimeMillis = currTime - this.lastActivatedTime;
            this.cumulativeActiveTimeMillis += activeTimeMillis;
        }
    }
}

