/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.server.servlet3;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.vibe.platform.Action;
import org.atmosphere.vibe.platform.Actions;
import org.atmosphere.vibe.platform.HttpStatus;
import org.atmosphere.vibe.platform.server.AbstractServerHttpExchange;

public class ServletServerHttpExchange
extends AbstractServerHttpExchange {
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public ServletServerHttpExchange(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        AsyncContext async = request.startAsync();
        async.setTimeout(0L);
        async.addListener(new AsyncListener(){

            public void onStartAsync(AsyncEvent event) throws IOException {
            }

            public void onComplete(AsyncEvent event) throws IOException {
            }

            public void onTimeout(AsyncEvent event) throws IOException {
                ServletServerHttpExchange.this.closeActions.fire();
            }

            public void onError(AsyncEvent event) throws IOException {
                ServletServerHttpExchange.this.errorActions.fire((Object)event.getThrowable());
            }
        });
    }

    public String uri() {
        String uri = this.request.getRequestURI();
        if (this.request.getQueryString() != null) {
            uri = uri + "?" + this.request.getQueryString();
        }
        return uri;
    }

    public String method() {
        return this.request.getMethod();
    }

    public Set<String> headerNames() {
        LinkedHashSet<String> headerNames = new LinkedHashSet<String>();
        Enumeration enumeration = this.request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            headerNames.add((String)enumeration.nextElement());
        }
        return headerNames;
    }

    public List<String> headers(String name) {
        return Collections.list(this.request.getHeaders(name));
    }

    protected void doRead(Action<ByteBuffer> chunkAction) {
        try {
            ServletInputStream input = this.request.getInputStream();
            int version = this.getServletMinorVersion();
            if (version > 0) {
                new AsyncBodyReader(input, chunkAction, (Actions<Void>)this.endActions, (Actions<Throwable>)this.errorActions);
            } else {
                new SyncBodyReader(input, chunkAction, (Actions<Void>)this.endActions, (Actions<Throwable>)this.errorActions);
            }
        }
        catch (IOException e) {
            this.errorActions.fire((Object)e);
        }
    }

    private int getServletMinorVersion() {
        String info;
        int version = this.request.getServletContext().getMinorVersion();
        if (version == 0 && ((info = this.request.getServletContext().getServerInfo()).startsWith("jetty/9.1") || info.startsWith("jetty/9.2"))) {
            version = 1;
        }
        return version;
    }

    protected void doSetStatus(HttpStatus status) {
        this.response.setStatus(status.code());
    }

    protected void doSetHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    protected void doWrite(ByteBuffer byteBuffer) {
        try {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            ServletOutputStream outputStream = this.response.getOutputStream();
            outputStream.write(bytes);
            outputStream.flush();
        }
        catch (IOException e) {
            this.errorActions.fire((Object)e);
        }
    }

    protected void doEnd() {
        this.request.getAsyncContext().complete();
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)(HttpServletRequest.class.isAssignableFrom(clazz) ? clazz.cast(this.request) : (HttpServletResponse.class.isAssignableFrom(clazz) ? clazz.cast(this.response) : null));
    }

    private static class SyncBodyReader
    extends BodyReader {
        public SyncBodyReader(ServletInputStream input, Action<ByteBuffer> action, Actions<Void> endActions, Actions<Throwable> errorActions) {
            super(input, action, endActions, errorActions);
        }

        @Override
        void start() {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        SyncBodyReader.this.read();
                        SyncBodyReader.this.end();
                    }
                    catch (IOException e) {
                        SyncBodyReader.this.errorActions.fire((Object)e);
                    }
                }
            }).start();
        }

        @Override
        boolean ready() {
            try {
                return this.input.available() > 0;
            }
            catch (IOException e) {
                this.errorActions.fire((Object)e);
                return false;
            }
        }
    }

    private static class AsyncBodyReader
    extends BodyReader {
        public AsyncBodyReader(ServletInputStream input, Action<ByteBuffer> action, Actions<Void> endActions, Actions<Throwable> errorActions) {
            super(input, action, endActions, errorActions);
        }

        @Override
        void start() {
            this.input.setReadListener(new ReadListener(){

                public void onDataAvailable() throws IOException {
                    AsyncBodyReader.this.read();
                }

                public void onAllDataRead() throws IOException {
                    AsyncBodyReader.this.end();
                }

                public void onError(Throwable t) {
                    AsyncBodyReader.this.errorActions.fire((Object)t);
                }
            });
        }

        @Override
        boolean ready() {
            return this.input.isReady();
        }
    }

    private static abstract class BodyReader {
        final ServletInputStream input;
        final Action<ByteBuffer> chunkAction;
        final Actions<Void> endActions;
        final Actions<Throwable> errorActions;

        public BodyReader(ServletInputStream input, Action<ByteBuffer> chunkAction, Actions<Void> endActions, Actions<Throwable> errorActions) {
            this.input = input;
            this.chunkAction = chunkAction;
            this.endActions = endActions;
            this.errorActions = errorActions;
            this.start();
        }

        abstract void start();

        void read() throws IOException {
            int bytesRead = -1;
            byte[] buffer = new byte[8192];
            while (this.ready() && (bytesRead = this.input.read(buffer)) != -1) {
                this.chunkAction.on((Object)ByteBuffer.wrap(buffer, 0, bytesRead));
            }
        }

        abstract boolean ready();

        void end() {
            this.endActions.fire();
        }
    }
}

