/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.server.servlet3;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.vibe.platform.Actions;
import org.atmosphere.vibe.platform.Data;
import org.atmosphere.vibe.platform.HttpStatus;
import org.atmosphere.vibe.platform.server.AbstractServerHttpExchange;

public class ServletServerHttpExchange
extends AbstractServerHttpExchange {
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public ServletServerHttpExchange(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        AsyncContext async = request.startAsync();
        async.setTimeout(0L);
        async.addListener(new AsyncListener(){

            public void onStartAsync(AsyncEvent event) throws IOException {
            }

            public void onTimeout(AsyncEvent event) throws IOException {
                ServletServerHttpExchange.this.closeActions.fire();
            }

            public void onError(AsyncEvent event) throws IOException {
                ServletServerHttpExchange.this.closeActions.fire();
            }

            public void onComplete(AsyncEvent event) throws IOException {
                ServletServerHttpExchange.this.closeActions.fire();
            }
        });
    }

    public String uri() {
        String uri = this.request.getRequestURI();
        if (this.request.getQueryString() != null) {
            uri = uri + "?" + this.request.getQueryString();
        }
        return uri;
    }

    public String method() {
        return this.request.getMethod();
    }

    public Set<String> headerNames() {
        LinkedHashSet<String> headerNames = new LinkedHashSet<String>();
        Enumeration enumeration = this.request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            headerNames.add((String)enumeration.nextElement());
        }
        return headerNames;
    }

    public List<String> headers(String name) {
        return Collections.list(this.request.getHeaders(name));
    }

    protected void readBody() {
        ServletInputStream input;
        try {
            input = this.request.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        String charsetName = this.request.getCharacterEncoding();
        Charset charset = Charset.forName(charsetName == null ? "ISO-8859-1" : charsetName);
        if (this.request.getServletContext().getMinorVersion() > 0) {
            new AsyncBodyReader(input, charset, (Actions<Data>)this.bodyActions);
        } else {
            new SyncBodyReader(input, charset, (Actions<Data>)this.bodyActions);
        }
    }

    protected void doSetHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    protected void doWrite(ByteBuffer byteBuffer) {
        try {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            ServletOutputStream outputStream = this.response.getOutputStream();
            outputStream.write(bytes);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doSetStatus(HttpStatus status) {
        this.response.setStatus(status.code());
    }

    protected void doWrite(String data) {
        try {
            PrintWriter writer = this.response.getWriter();
            writer.print(data);
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doClose() {
        this.request.getAsyncContext().complete();
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)(HttpServletRequest.class.isAssignableFrom(clazz) ? clazz.cast(this.request) : (HttpServletResponse.class.isAssignableFrom(clazz) ? clazz.cast(this.response) : null));
    }

    private static class SyncBodyReader
    extends BodyReader {
        public SyncBodyReader(ServletInputStream input, Charset charset, Actions<Data> bodyActions) {
            super(input, charset, bodyActions);
        }

        @Override
        void start() {
            try {
                this.read();
                this.end();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        boolean ready() {
            return true;
        }
    }

    private static class AsyncBodyReader
    extends BodyReader {
        public AsyncBodyReader(ServletInputStream input, Charset charset, Actions<Data> bodyActions) {
            super(input, charset, bodyActions);
        }

        @Override
        void start() {
            this.input.setReadListener(new ReadListener(){

                public void onDataAvailable() throws IOException {
                    AsyncBodyReader.this.read();
                }

                public void onAllDataRead() throws IOException {
                    AsyncBodyReader.this.end();
                }

                public void onError(Throwable t) {
                    throw new RuntimeException(t);
                }
            });
        }

        @Override
        boolean ready() {
            return this.input.isReady();
        }
    }

    private static abstract class BodyReader {
        final ServletInputStream input;
        final Charset charset;
        final Actions<Data> actions;
        final StringBuilder body = new StringBuilder();

        public BodyReader(ServletInputStream input, Charset charset, Actions<Data> bodyActions) {
            this.input = input;
            this.charset = charset;
            this.actions = bodyActions;
            this.start();
        }

        abstract void start();

        void read() throws IOException {
            int bytesRead = -1;
            byte[] buffer = new byte[4096];
            while (this.ready() && (bytesRead = this.input.read(buffer)) != -1) {
                String data = new String(buffer, 0, bytesRead, this.charset);
                this.body.append(data);
            }
        }

        abstract boolean ready();

        void end() {
            this.actions.fire((Object)new Data(this.body.toString()));
        }
    }
}

