/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.Serializer;
import org.atmosphere.samples.ChatController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"chat"})
public class ChatController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private BroadcasterFactory broadcasterFactory;
    private static final ObjectMapper jackson = new ObjectMapper();
    private Serializer jsonSerializer = new /* Unavailable Anonymous Inner Class!! */;

    private Broadcaster getBroadcaster(String name) {
        Broadcaster b = this.broadcasterFactory.lookup((Object)name);
        if (b == null) {
            b = this.broadcasterFactory.get((Object)name);
            this.logger.info("create new broadcaster (name : {}) : {}", (Object)name, (Object)b);
            return b;
        }
        return b;
    }

    @RequestMapping(value={"connect"})
    public void openWsSession(AtmosphereResource resource) {
        this.logger.info("new ws resource : {}", (Object)resource);
        if (this.broadcasterFactory == null) {
            this.broadcasterFactory = resource.getAtmosphereConfig().getBroadcasterFactory();
        }
        resource.setSerializer(this.jsonSerializer);
        Broadcaster broadcaster = this.getBroadcaster("/chat");
        broadcaster.addAtmosphereResource(resource);
    }

    @RequestMapping(value={"sendMessage"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void sendMessage(@RequestBody Message message) throws JsonProcessingException {
        Broadcaster broadcaster = this.getBroadcaster("/chat");
        this.logger.info("broadcast message to {} resources", (Object)broadcaster.getAtmosphereResources().size());
        broadcaster.broadcast((Object)message);
    }

    static /* synthetic */ ObjectMapper access$000() {
        return jackson;
    }
}

