/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.chat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.atmosphere.config.service.AtmosphereHandlerService;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.samples.chat.ChatJSONObject;
import org.atmosphere.socketio.SocketIOSessionOutbound;
import org.atmosphere.socketio.cache.SocketIOBroadcasterCache;
import org.atmosphere.socketio.cpr.SocketIOAtmosphereHandler;
import org.atmosphere.socketio.transport.DisconnectReason;
import org.atmosphere.socketio.transport.SocketIOPacketImpl;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereHandlerService(path="/*", supportSession=true, broadcasterCache=SocketIOBroadcasterCache.class)
public class NativeSocketIOAtmosphereHandler
extends SocketIOAtmosphereHandler {
    private static final Logger logger = LoggerFactory.getLogger(NativeSocketIOAtmosphereHandler.class);
    private final ConcurrentMap<String, String> loggedUserMap = new ConcurrentSkipListMap();
    private final ObjectMapper mapper = new ObjectMapper();
    private Broadcaster broadcaster;

    public void onConnect(AtmosphereResource r, SocketIOSessionOutbound outbound) throws IOException {
        logger.debug("onConnect");
        this.broadcaster = r.getBroadcaster();
    }

    public void onMessage(AtmosphereResource r, SocketIOSessionOutbound outbound, String message) {
        if (outbound == null || message == null || message.length() == 0) {
            return;
        }
        try {
            logger.debug("onMessage on SessionID=" + outbound.getSessionId() + "  : Message Received = " + message);
            ChatJSONObject chat = (ChatJSONObject)this.mapper.readValue(message, ChatJSONObject.class);
            if ("nickname".equalsIgnoreCase(chat.name)) {
                r.session().setAttribute("LOGINNAME", chat.getArgs().toArray()[0]);
                String username = (String)chat.getArgs().toArray()[0];
                if (this.loggedUserMap.containsValue(username)) {
                    outbound.sendMessage(new SocketIOPacketImpl(SocketIOPacketImpl.PacketType.ACK, "1+[true]").toString());
                } else {
                    this.loggedUserMap.put(outbound.getSessionId(), username);
                    try {
                        ChatJSONObject out = new ChatJSONObject();
                        out.setName("nicknames");
                        ArrayList<ConcurrentMap> list = new ArrayList<ConcurrentMap>();
                        list.add(this.loggedUserMap);
                        out.setArgs(list);
                        ArrayList<SocketIOPacketImpl> loginMessagesList = new ArrayList<SocketIOPacketImpl>(2);
                        loginMessagesList.add(new SocketIOPacketImpl(SocketIOPacketImpl.PacketType.ACK, "1+[false]"));
                        loginMessagesList.add(new SocketIOPacketImpl(SocketIOPacketImpl.PacketType.EVENT, this.mapper.writeValueAsString((Object)out)));
                        outbound.sendMessage(loginMessagesList);
                        this.broadcaster.broadcast((Object)this.mapper.writeValueAsString((Object)out), r);
                        this.broadcaster.broadcast((Object)("{\"args\":[\"" + chat.getArgs().toArray()[0] + " connected\"],\"name\":\"announcement\"}"), r);
                        logger.trace("Broadcasting on SessionID=" + outbound.getSessionId() + "  LOGIN is completed");
                    }
                    catch (Exception e) {
                        logger.error("", (Throwable)e);
                        outbound.disconnect();
                    }
                }
            } else if ("user message".equalsIgnoreCase(chat.name)) {
                String username = (String)this.loggedUserMap.get(outbound.getSessionId());
                ArrayList<String> msg = new ArrayList<String>();
                msg.add(username);
                msg.addAll(chat.args);
                ChatJSONObject out = new ChatJSONObject();
                out.setName("user message");
                out.setArgs(msg);
                this.broadcaster.broadcast((Object)this.mapper.writeValueAsString((Object)out), r);
                logger.trace("Broadcasting on SessionID=" + outbound.getSessionId() + "  MESSAGE is completed");
            }
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
    }

    public void onDisconnect(AtmosphereResource r, SocketIOSessionOutbound outbound, DisconnectReason reason) {
        logger.debug("onDisconnect from sessionid = " + outbound.getSessionId() + " username=" + (String)this.loggedUserMap.get(outbound.getSessionId()));
        String sessionid = outbound.getSessionId();
        String username = (String)this.loggedUserMap.get(sessionid);
        this.broadcaster.broadcast((Object)("{\"name\":\"announcement\",\"args\":[\"" + username + " disconnected\"]}"), r);
        this.loggedUserMap.remove(sessionid);
        ObjectMapper mapper = new ObjectMapper();
        ChatJSONObject out = new ChatJSONObject();
        out.setName("nicknames");
        ArrayList<ConcurrentMap> list = new ArrayList<ConcurrentMap>();
        list.add(this.loggedUserMap);
        out.setArgs(list);
        try {
            this.broadcaster.broadcast((Object)new SocketIOPacketImpl(SocketIOPacketImpl.PacketType.EVENT, mapper.writeValueAsString((Object)out), false).toString(), r);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        logger.trace("Broadcasting on SessionID=" + outbound.getSessionId() + "  DISCONNECT is completed");
    }
}

