/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.pubsub;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.config.service.MeteorService;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.Meteor;
import org.atmosphere.websocket.WebSocketEventListenerAdapter;

@MeteorService(path="/pubsub/{topic}")
public class MeteorPubSub
extends HttpServlet {
    @Inject
    @Named(value="/{topic}")
    private Broadcaster broadcaster;

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        Meteor m = Meteor.build((HttpServletRequest)req);
        m.addListener((AtmosphereResourceEventListener)new WebSocketEventListenerAdapter());
        res.setContentType("text/html;charset=ISO-8859-1");
        m.setBroadcaster(this.broadcaster);
        m.suspend(-1L);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String message = req.getReader().readLine();
        if (message != null && message.indexOf("message") != -1) {
            this.broadcaster.broadcast((Object)message.substring("message=".length()));
        }
    }
}

