/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.di.guice;

import com.google.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.samples.di.guice.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventsLogger
implements AtmosphereResourceEventListener {
    private static final Logger logger = LoggerFactory.getLogger(EventsLogger.class);
    @Inject
    private Service service;

    public void onSuspend(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        if (this.service == null) {
            throw new AssertionError();
        }
        logger.info("[{}] onSuspend: {}:{}", new Object[]{Thread.currentThread().getName(), ((HttpServletRequest)event.getResource().getRequest()).getRemoteAddr(), ((HttpServletRequest)event.getResource().getRequest()).getRemotePort()});
    }

    public void onResume(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        if (this.service == null) {
            throw new AssertionError();
        }
        logger.info("[{}] onResume: {}:{}", new Object[]{Thread.currentThread().getName(), ((HttpServletRequest)event.getResource().getRequest()).getRemoteAddr(), ((HttpServletRequest)event.getResource().getRequest()).getRemotePort()});
    }

    public void onDisconnect(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        if (this.service == null) {
            throw new AssertionError();
        }
        logger.info("[{}] onDisconnect: {}:{}", new Object[]{Thread.currentThread().getName(), ((HttpServletRequest)event.getResource().getRequest()).getRemoteAddr(), ((HttpServletRequest)event.getResource().getRequest()).getRemotePort()});
    }

    public void onBroadcast(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        if (this.service == null) {
            throw new AssertionError();
        }
        logger.info("[{}] onBroadcast: {}:{}", new Object[]{Thread.currentThread().getName(), ((HttpServletRequest)event.getResource().getRequest()).getRemoteAddr(), ((HttpServletRequest)event.getResource().getRequest()).getRemotePort()});
    }

    public void onThrowable(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        if (this.service == null) {
            throw new AssertionError();
        }
        logger.info("[{}] onThrowable: " + ((HttpServletRequest)event.getResource().getRequest()).getRemoteAddr() + ":" + ((HttpServletRequest)event.getResource().getRequest()).getRemotePort(), event.throwable());
    }
}

