/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.samples.greeter.cxf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.Response;
import org.atmosphere.samples.greeter.cxf.api.DefaultApi;
import org.atmosphere.samples.greeter.cxf.model.Body;
import org.atmosphere.samples.greeter.cxf.model.EchoReply;
import org.atmosphere.samples.greeter.cxf.model.GreetingReply;
import org.atmosphere.samples.greeter.cxf.model.GreetingStatus;
import org.atmosphere.samples.greeter.cxf.model.GreetingSummary;
import org.atmosphere.samples.greeter.cxf.model.Pong;

public class DefaultGreeter
implements DefaultApi {
    private AtomicInteger count = new AtomicInteger();
    private AtomicInteger totalgreeted = new AtomicInteger();
    private Map<String, AtomicInteger> greeted = new HashMap();

    public Response echo(String body) {
        EchoReply r = new EchoReply();
        r.setEcho(body);
        return Response.ok((Object)r, (String)"application/json").build();
    }

    public Response getGreetStatus(String name) {
        GreetingStatus r = new GreetingStatus();
        r.setName(name);
        AtomicInteger greetedcount = (AtomicInteger)this.greeted.get(name);
        r.setCount(Integer.valueOf(greetedcount == null ? 0 : greetedcount.get()));
        return Response.ok((Object)r, (String)"application/json").build();
    }

    public Response getGreetSummary() {
        GreetingSummary r = new GreetingSummary();
        r.setTotal(Integer.valueOf(this.totalgreeted.get()));
        r.setGreeted(new ArrayList(this.greeted.keySet()));
        return Response.ok((Object)r, (String)"application/json").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response greet(String name, Body body) {
        AtomicInteger greetedcount;
        Map map = this.greeted;
        synchronized (map) {
            greetedcount = (AtomicInteger)this.greeted.get(name);
            if (greetedcount == null) {
                greetedcount = new AtomicInteger();
                this.greeted.put(name, greetedcount);
            }
        }
        GreetingReply r = new GreetingReply();
        r.setFrom(body.getName());
        r.setName(name);
        r.setText(body.getText());
        this.totalgreeted.incrementAndGet();
        greetedcount.incrementAndGet();
        return Response.ok((Object)r, (String)"application/json").build();
    }

    public Response ping() {
        System.out.printf("########## greeter ping called", new Object[0]);
        Pong r = new Pong();
        r.setPong(Integer.valueOf(this.count.incrementAndGet()));
        return Response.ok((Object)r, (String)"application/json").build();
    }
}

