/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.plugin.rabbitmq.RabbitMQBroadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQConnectionFactory
implements AtmosphereConfig.ShutdownHook {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMQBroadcaster.class);
    private static RabbitMQConnectionFactory factory;
    public static final String PARAM_HOST;
    public static final String PARAM_USER;
    public static final String PARAM_PASS;
    public static final String PARAM_EXCHANGE_TYPE;
    public static final String PARAM_VHOST;
    public static final String PARAM_PORT;
    private String exchangeName;
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Channel channel;
    private String exchange;

    public RabbitMQConnectionFactory(AtmosphereConfig config) {
        String password;
        String port;
        String user;
        String vhost;
        String s = config.getInitParameter(PARAM_EXCHANGE_TYPE);
        this.exchange = s != null ? s : "topic";
        String host = config.getInitParameter(PARAM_HOST);
        if (host == null) {
            host = "127.0.0.1";
        }
        if ((vhost = config.getInitParameter(PARAM_VHOST)) == null) {
            vhost = "/";
        }
        if ((user = config.getInitParameter(PARAM_USER)) == null) {
            user = "guest";
        }
        if ((port = config.getInitParameter(PARAM_PORT)) == null) {
            port = "5672";
        }
        if ((password = config.getInitParameter(PARAM_PASS)) == null) {
            password = "guest";
        }
        this.exchangeName = "atmosphere." + this.exchange;
        try {
            logger.debug("Create Connection Factory");
            this.connectionFactory = new ConnectionFactory();
            this.connectionFactory.setUsername(user);
            this.connectionFactory.setPassword(password);
            this.connectionFactory.setVirtualHost(vhost);
            this.connectionFactory.setHost(host);
            this.connectionFactory.setPort(Integer.valueOf(port).intValue());
            logger.debug("Try to acquire a connection ...");
            this.connection = this.connectionFactory.newConnection();
            this.channel = this.connection.createChannel();
            logger.debug("Topic creation '{}'...", (Object)this.exchangeName);
            this.channel.exchangeDeclare(this.exchangeName, this.exchange);
        }
        catch (Exception e) {
            String msg = "Unable to configure RabbitMQBroadcaster";
            logger.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        config.shutdownHook((AtmosphereConfig.ShutdownHook)this);
    }

    public static final RabbitMQConnectionFactory getFactory(AtmosphereConfig config) {
        if (factory == null) {
            factory = new RabbitMQConnectionFactory(config);
        }
        return factory;
    }

    public String exchangeName() {
        return this.exchangeName;
    }

    public Channel channel() {
        return this.channel;
    }

    public void shutdown() {
        try {
            this.channel.close();
            this.connection.close();
        }
        catch (IOException e) {
            logger.trace("", (Throwable)e);
        }
    }

    static {
        PARAM_HOST = RabbitMQBroadcaster.class.getName() + ".host";
        PARAM_USER = RabbitMQBroadcaster.class.getName() + ".user";
        PARAM_PASS = RabbitMQBroadcaster.class.getName() + ".password";
        PARAM_EXCHANGE_TYPE = RabbitMQBroadcaster.class.getName() + ".exchange";
        PARAM_VHOST = RabbitMQBroadcaster.class.getName() + ".vhost";
        PARAM_PORT = RabbitMQBroadcaster.class.getName() + ".port";
    }
}

